/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.PropertyPermissionCollection;

public final class PropertyPermission
extends BasicPermission {
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("action", PropertyPermission.class$("java.lang.String"))};
    private static final long serialVersionUID = 885438825399942851L;
    private static final int READ = 1;
    private static final int WRITE = 2;
    transient int actions;
    private static final String[] actionStrings = new String[]{"", "read", "write", "read,write"};

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public PropertyPermission(String name, String actions) {
        super(name);
        if (actions == null) {
            throw new IllegalArgumentException();
        }
        this.setActions(actions.toLowerCase());
    }

    private void setActions(String str) {
        if ("read".equals(str)) {
            this.actions = 1;
        } else if ("write".equals(str)) {
            this.actions = 2;
        } else if ("read,write".equals(str) || "write,read".equals(str)) {
            this.actions = 3;
        } else {
            throw new IllegalArgumentException("illegal action " + str);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = s.readFields();
        this.setActions((String)fields.get("actions", null));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("actions", this.getActions());
        s.writeFields();
    }

    public boolean implies(Permission p) {
        if (super.implies(p)) {
            PropertyPermission pp = (PropertyPermission)p;
            return (pp.actions & ~this.actions) == 0;
        }
        return false;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.actions == ((PropertyPermission)obj).actions;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getActions() {
        return actionStrings[this.actions];
    }

    public PermissionCollection newPermissionCollection() {
        return new PropertyPermissionCollection();
    }
}

