/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.java.nio.DoubleBufferImpl;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public abstract class DoubleBuffer
extends Buffer
implements Comparable {
    protected double[] backing_buffer;
    protected int array_offset;

    public static DoubleBuffer allocateDirect(int capacity) {
        throw new Error("direct buffers are not implemented");
    }

    public static DoubleBuffer allocate(int capacity) {
        return new DoubleBufferImpl(capacity, 0, capacity);
    }

    public static final DoubleBuffer wrap(double[] array, int offset, int length) {
        return new DoubleBufferImpl(array, offset, length);
    }

    public static final DoubleBuffer wrap(String a) {
        int len = a.length();
        double[] buffer = new double[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = a.charAt(i);
        }
        return DoubleBuffer.wrap(buffer, 0, len);
    }

    public static final DoubleBuffer wrap(double[] array) {
        return DoubleBuffer.wrap(array, 0, array.length);
    }

    DoubleBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }

    public DoubleBuffer get(double[] dst, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public DoubleBuffer get(double[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public DoubleBuffer put(DoubleBuffer src) {
        while (src.hasRemaining()) {
            this.put(src.get());
        }
        return this;
    }

    public DoubleBuffer put(double[] src, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final DoubleBuffer put(double[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && this.isReadOnly() ^ true;
    }

    public final double[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleBuffer) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    public int compareTo(Object ob) {
        DoubleBuffer a = (DoubleBuffer)ob;
        if (a.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !a.hasArray()) {
            return 1;
        }
        int r = this.remaining();
        int i1 = this.position();
        int i2 = a.position();
        for (int i = 0; i < r; ++i) {
            int t = (int)(this.get(i1) - a.get(i2));
            if (t == 0) continue;
            return t;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract double get();

    public abstract DoubleBuffer put(double var1);

    public abstract double get(int var1);

    public abstract DoubleBuffer put(int var1, double var2);

    public abstract DoubleBuffer compact();

    public abstract boolean isDirect();

    public abstract DoubleBuffer slice();

    public abstract DoubleBuffer duplicate();

    public abstract DoubleBuffer asReadOnlyBuffer();
}

