/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.event.KeyEvent;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class AWTKeyStroke
implements Serializable {
    private static final long serialVersionUID = -6430539691155161871L;
    private static final int MODIFIERS_MASK = 16367;
    private static final LinkedHashMap cache = new LinkedHashMap(null, 11, 0.75f, true){
        private /* synthetic */ AWTKeyStroke this$0;
        private static final int MAX_CACHE_SIZE = 2048;
        {
            this.this$0 = this$0;
            super(parm0, parm1, parm2);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 2048;
        }
    };
    private static AWTKeyStroke recent;
    private static Constructor ctor;
    private static final HashMap vktable;
    private char keyChar;
    int keyCode;
    private int modifiers;
    private boolean onKeyRelease;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    protected AWTKeyStroke() {
        this.keyChar = (char)65535;
    }

    protected AWTKeyStroke(char keyChar, int keyCode, int modifiers, boolean onKeyRelease) {
        this.keyChar = keyChar;
        this.keyCode = keyCode;
        this.modifiers = modifiers;
        this.onKeyRelease = onKeyRelease;
    }

    protected static void registerSubclass(Class subclass) {
        if (subclass == null) {
            throw new IllegalArgumentException();
        }
        if (subclass.equals(ctor == null ? AWTKeyStroke.class$("java.awt.AWTKeyStroke") : ctor.getDeclaringClass())) {
            return;
        }
        if (subclass.equals(AWTKeyStroke.class$("java.awt.AWTKeyStroke"))) {
            cache.clear();
            recent = null;
            ctor = null;
            return;
        }
        try {
            ctor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(null, subclass){
                private /* synthetic */ AWTKeyStroke this$0;
                private /* synthetic */ Class val$subclass;
                {
                    this.this$0 = this$0;
                    this.finit$(parm$subclass);
                }

                private /* synthetic */ void finit$(Class parm$subclass) {
                    this.val$subclass = parm$subclass;
                }

                public Object run() throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
                    Constructor c = this.val$subclass.getDeclaredConstructor(null);
                    c.setAccessible(true);
                    AWTKeyStroke dummy = (AWTKeyStroke)c.newInstance(null);
                    return c;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)new IllegalArgumentException().initCause(e.getCause());
        }
        cache.clear();
        recent = null;
    }

    public static AWTKeyStroke getAWTKeyStroke(char keyChar) {
        return AWTKeyStroke.getAWTKeyStroke(keyChar, 0, 0, false);
    }

    public static AWTKeyStroke getAWTKeyStroke(Character keyChar, int modifiers) {
        if (keyChar == null) {
            throw new IllegalArgumentException();
        }
        return AWTKeyStroke.getAWTKeyStroke(keyChar.charValue(), 0, AWTKeyStroke.extend(modifiers), false);
    }

    public static AWTKeyStroke getAWTKeyStroke(int keyCode, int modifiers, boolean release) {
        return AWTKeyStroke.getAWTKeyStroke('\uffff', keyCode, AWTKeyStroke.extend(modifiers), release);
    }

    public static AWTKeyStroke getAWTKeyStroke(int keyCode, int modifiers) {
        return AWTKeyStroke.getAWTKeyStroke('\uffff', keyCode, AWTKeyStroke.extend(modifiers), false);
    }

    public static AWTKeyStroke getAWTKeyStrokeForEvent(KeyEvent event) {
        switch (event.id) {
            case 400: {
                return AWTKeyStroke.getAWTKeyStroke(event.getKeyChar(), 0, AWTKeyStroke.extend(event.getModifiersEx()), false);
            }
            case 401: {
                return AWTKeyStroke.getAWTKeyStroke('\uffff', event.getKeyCode(), AWTKeyStroke.extend(event.getModifiersEx()), false);
            }
            case 402: {
                return AWTKeyStroke.getAWTKeyStroke('\uffff', event.getKeyCode(), AWTKeyStroke.extend(event.getModifiersEx()), true);
            }
        }
        return null;
    }

    public static AWTKeyStroke getAWTKeyStroke(String s) {
        StringTokenizer t = new StringTokenizer(s, " ");
        if (!t.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        int modifiers = 0;
        boolean released = false;
        String token = null;
        do {
            if ("shift".equals(token = t.nextToken())) {
                modifiers |= 0x41;
                continue;
            }
            if ("ctrl".equals(token) || "control".equals(token)) {
                modifiers |= 0x82;
                continue;
            }
            if ("meta".equals(token)) {
                modifiers |= 0x104;
                continue;
            }
            if ("alt".equals(token)) {
                modifiers |= 0x208;
                continue;
            }
            if ("button1".equals(token)) {
                modifiers |= 0x400;
                continue;
            }
            if ("button2".equals(token)) {
                modifiers |= 0x800;
                continue;
            }
            if ("button3".equals(token)) {
                modifiers |= 0x1000;
                continue;
            }
            if ("typed".equals(token)) {
                if (t.hasMoreTokens()) {
                    token = t.nextToken();
                    if (!t.hasMoreTokens() && token.length() == 1) {
                        return AWTKeyStroke.getAWTKeyStroke(token.charAt(0), 0, modifiers, false);
                    }
                }
                throw new IllegalArgumentException();
            }
            if ("pressed".equals(token)) {
                if (!t.hasMoreTokens()) break;
                token = t.nextToken();
                break;
            }
            if (!"released".equals(token)) break;
            released = true;
            if (!t.hasMoreTokens()) break;
            token = t.nextToken();
            break;
        } while (t.hasMoreTokens());
        Integer code = (Integer)vktable.get(token);
        if (code == null || t.hasMoreTokens()) {
            throw new IllegalArgumentException();
        }
        return AWTKeyStroke.getAWTKeyStroke('\uffff', code, modifiers, released);
    }

    public final char getKeyChar() {
        return this.keyChar;
    }

    public final int getKeyCode() {
        return this.keyCode;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final boolean isOnKeyRelease() {
        return this.onKeyRelease;
    }

    public final int getKeyEventType() {
        if (this.keyCode == 0) {
            return 400;
        }
        if (this.onKeyRelease) {
            return 402;
        }
        return 401;
    }

    public int hashCode() {
        return (this.keyChar + '\u0001') * (this.keyCode + 1) * (this.modifiers + 1) * 2 + (this.onKeyRelease ? 1 : 2);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof AWTKeyStroke)) {
            return false;
        }
        AWTKeyStroke s = (AWTKeyStroke)o;
        return this == o || this.keyChar == s.keyChar && this.keyCode == s.keyCode && this.modifiers == s.modifiers && this.onKeyRelease == s.onKeyRelease;
    }

    public String toString() {
        if (this.keyCode == 0) {
            return "keyChar " + KeyEvent.getKeyModifiersText(this.modifiers) + this.keyChar;
        }
        return "keyCode " + KeyEvent.getKeyModifiersText(this.modifiers) + KeyEvent.getKeyText(this.keyCode) + (this.onKeyRelease ? "-R" : "-P");
    }

    protected Object readResolve() throws ObjectStreamException {
        AWTKeyStroke s = (AWTKeyStroke)cache.get(this);
        if (s != null) {
            return s;
        }
        cache.put(this, this);
        return this;
    }

    private static AWTKeyStroke getAWTKeyStroke(char keyChar, int keyCode, int modifiers, boolean release) {
        AWTKeyStroke stroke = recent;
        if (stroke != null && stroke.keyChar == keyChar && stroke.keyCode == keyCode && stroke.modifiers == modifiers && stroke.onKeyRelease == release) {
            return stroke;
        }
        Constructor c = ctor;
        if (c == null) {
            stroke = new AWTKeyStroke(keyChar, keyCode, modifiers, release);
        } else {
            try {
                stroke = (AWTKeyStroke)c.newInstance(null);
                stroke.keyChar = keyChar;
                stroke.keyCode = keyCode;
                stroke.modifiers = modifiers;
                stroke.onKeyRelease = release;
            }
            catch (Exception e) {
                throw (Error)new InternalError().initCause(e);
            }
        }
        AWTKeyStroke cached = (AWTKeyStroke)cache.get(stroke);
        if (cached == null) {
            cache.put(stroke, stroke);
        } else {
            stroke = cached;
        }
        recent = stroke;
        return recent;
    }

    private static int extend(int mod) {
        if ((mod & 0x41) != 0) {
            mod |= 0x41;
        }
        if ((mod & 0x82) != 0) {
            mod |= 0x82;
        }
        if ((mod & 0x104) != 0) {
            mod |= 0x104;
        }
        if ((mod & 0x208) != 0) {
            mod |= 0x208;
        }
        if ((mod & 0x2020) != 0) {
            mod |= 0x2020;
        }
        if ((mod & 0x10) != 0) {
            mod |= 0x400;
        }
        return mod & 0x3FEF;
    }

    static {
        vktable = new HashMap();
        AccessController.doPrivileged(new PrivilegedAction(null){
            private /* synthetic */ AWTKeyStroke this$0;
            {
                this.this$0 = this$0;
            }

            static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
                try {
                    return Class.forName(type$);
                }
                catch (ClassNotFoundException write_parm_value$) {
                    throw new NoClassDefFoundError(write_parm_value$.getMessage());
                }
            }

            public Object run() {
                Field[] fields = 2.class$("java.awt.event.KeyEvent").getFields();
                int i = fields.length;
                try {
                    while (--i >= 0) {
                        Field f = fields[i];
                        String name = f.getName();
                        if (!name.startsWith("VK_")) continue;
                        vktable.put(name.substring(3), f.get(null));
                    }
                }
                catch (Exception e) {
                    throw (Error)new InternalError().initCause(e);
                }
                return null;
            }
        });
    }
}

