/*
 * Copyright (c) 2003 Danny Milosavljevic <danny_milo@yahoo.com>
 * Copyright (c) 2003 Benedikt Meurer <benedikt.meurer@unix-ag.uni-siegen.de>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_TIME_H
#include <time.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif
#include <string.h>

#include <libxfce4util/i18n.h>
#include <libxfcegui4/xfce_iconbutton.h>

#include <panel/global.h>
#include <panel/controls.h>
#include <panel/icons.h>
#include <panel/plugins.h>
#include <panel/xfce_support.h>
#include <panel/item_dialog.h>

/* for xml: */
#define TWOSTATE_LAUNCHER_ROOT "TriggerLauncher"

static GtkTooltips *tooltips = NULL;

typedef struct {
    char		*command;
    
    char		*tooltip;
    
    char		*icon1; /* _off; */
    char		*icon2; /* _on; */

    double		timeout;    

} TvOptions;

/*  Twostate Launcher module
 *  --------------------------
*/
typedef struct
{
    GtkBox		*hbox;
    GtkWidget		*launcher;           /* our Xfce Launch widget */

	/* Settings */
	
    GtkContainer	*settings_c;
    GtkSizeGroup	*sg;
    GtkWidget		*dialog;
    TvOptions		options;
    guint		timeout_handle;

	/* State */
	gboolean	switched_on;


}
t_tl;

static char *
P_(char const *s)
{
	return dgettext("xfce4-panel", s);
}

#if 0
static void 
swap_pixbuf_ptrs (GdkPixbuf **a, GdkPixbuf **b)
{
	GdkPixbuf *tmp;
	tmp = *a;
	*a = *b;
	*b = tmp;
}
#endif

static GdkPixbuf *
xfce_tl_get_pixbuf_for(t_tl *tl, gboolean on)
{
	GdkPixbuf	*pb;
	char	*i = tl->options.icon1;
	if (on) i = tl->options.icon2;
	
	if (i) {
		pb = gdk_pixbuf_new_from_file(i, NULL);
	} else {
		pb = get_pixbuf_by_id(DEFAULT_ICON);
	}

	return (pb);
}

/* creation and destruction */

static GtkWidget *
xfce_tl_new(void)
{
	XfceIconbutton *ib;
	GdkPixbuf *pb;
	
	pb = get_pixbuf_by_id(DEFAULT_ICON); /*xfce_tl_get_pixbuf_for(on);*/

	ib = (XfceIconbutton *)xfce_iconbutton_new_from_pixbuf(pb);
	gtk_button_set_relief(GTK_BUTTON(ib), GTK_RELIEF_NONE);
	g_object_unref(pb);

/*	if (ib) {	
	}
*/
	return (GtkWidget *)ib;
}

static gboolean
update_state(t_tl *tl)
{
	gchar *caption;
	GdkPixbuf	*pb;

	char *s = "on";
	if (!tl->switched_on) {
		s = "off";
	}
	pb = xfce_tl_get_pixbuf_for(tl, tl->switched_on);
	xfce_iconbutton_set_pixbuf(XFCE_ICONBUTTON(tl->launcher), pb);
	g_object_unref(pb);
	if (tl->options.tooltip){
	 caption=g_strconcat(tl->options.tooltip,": ",s,NULL);
	} else {
	 caption=g_strdup(s);
	}

	gtk_tooltips_set_tip(tooltips, GTK_WIDGET(tl->hbox), caption,
			NULL);
	gtk_tooltips_set_tip(tooltips, GTK_WIDGET(tl->launcher), caption,
			NULL);
	g_free(caption);

	return(FALSE);
}

static gboolean launch_me(t_tl *tl, gboolean check_only)
{
	char	*tmp = NULL;
	FILE	*file;
	char	s[100];
	int	state;
	
	if (!tl->options.command) {
		return FALSE;
	}
	
	if (!check_only) {
		tmp = g_strdup_printf("%s %d", tl->options.command, 
			tl->switched_on ? 1 : 0);
			
		exec_cmd(tmp, FALSE, FALSE);
		g_free(tmp);

		return TRUE;
	} else {
		state = 0;
		
		signal(SIGPIPE, SIG_IGN);
		file = popen(tl->options.command, "r");
		
		if (file) {
			if (fgets(s, sizeof(s), file)) {
				if (sscanf(s, "%d", &state) == 1) {
				}
			}
		}
		/*xfce_info("%X: %d", file, state);*/
		
		fclose(file);
		signal(SIGPIPE, SIG_DFL);
		
		return (state ? TRUE : FALSE);
	}
}

static
gboolean
tl_timeout_cb(gpointer d)
{
	t_tl *tl = (t_tl *)d;
	tl->switched_on = launch_me(tl, TRUE);
	update_state(tl);
	return TRUE;
}

static
void tl_timeout_changed(t_tl *tl)
{
	if (tl->timeout_handle) {
		g_source_remove (tl->timeout_handle);
		tl->timeout_handle = 0;
	}
	if (tl->options.timeout != 0.0) {
		tl->timeout_handle = g_timeout_add (tl->options.timeout * 1000.0, tl_timeout_cb, tl);
	}
}

static
void tl_timeout_create_options(t_tl *tl)
{
	GtkWidget *h;
	GtkWidget *c1;
	GtkWidget *r;
	GtkWidget *l2;

	h = gtk_hbox_new (FALSE, 5);
	gtk_widget_show (h);
	
	c1 = gtk_check_button_new_with_label (_("Check status every"));
	gtk_widget_show (c1);
	
	r = gtk_spin_button_new_with_range (0.0, 1000.0, 0.1);
	gtk_spin_button_set_digits (GTK_SPIN_BUTTON (r), 1);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (r), tl->options.timeout);
	gtk_widget_show (r);


	l2 = gtk_label_new (_("seconds"));
	gtk_widget_show (l2);
	
	gtk_box_pack_start_defaults (GTK_BOX(h), c1);
	gtk_box_pack_start_defaults (GTK_BOX(h), r);
	gtk_box_pack_start_defaults (GTK_BOX(h), l2);
		
	gtk_box_pack_end_defaults (GTK_BOX(tl->settings_c), h);
}



static t_tl *
tl_new (void)
{
    t_tl *tl;
    
    tl = g_new0 (t_tl, 1);

    tl->options.timeout = 10.0;

    tl->switched_on = FALSE;
/*    update_state(tl);*/
    
    tl->options.command = NULL; /* g_strdup("bin/tvout");*/
    tl->options.tooltip = NULL; /*g_strdup("Two-State Launcher");*/
    tl->options.icon1 = NULL; /*g_strdup("/tmp/tvout-off.png");*/
    tl->options.icon2 = NULL; /*g_strdup("/tmp/tvout-on.png");*/
    
    tl->hbox = GTK_BOX(gtk_hbox_new(FALSE, 0));
    gtk_widget_set_name (GTK_WIDGET(tl->hbox), "xfce_tl");
    gtk_container_set_border_width(GTK_CONTAINER(tl->hbox), border_width);

    gtk_widget_show(GTK_WIDGET(tl->hbox));

    tl->launcher = xfce_tl_new ();
    gtk_widget_show (tl->launcher);
    gtk_box_pack_start (GTK_BOX(tl->hbox), GTK_WIDGET(tl->launcher), FALSE, 
    	FALSE, 0);

    tl->switched_on = launch_me(tl, TRUE);

    tl_timeout_changed (tl);

    return tl;
}



static void
xfce_tl_launch_button_cb(GtkWidget *button, t_tl *tl) /* verified prototype: clicked */
{
	if (!tl->options.command) return;
	tl->switched_on = !tl->switched_on;
	launch_me(tl, FALSE);
	update_state(tl);
}



static void
tl_set_theme(Control * control, const char *theme)
{
	t_tl		*tl;
	
	tl = (t_tl *)control->data;
	
}


static void
free_optionsdialog(t_tl *tl)
{
/*	if (tl->revert.command) {
		g_free(tl->revert.command); 
		tl->revert.command = NULL;
	}
	
	if (tl->revert.tooltip) {
		g_free(tl->revert.tooltip);
		tl->revert.tooltip = NULL;
	}
	
	if (tl->revert.icon1) {
		g_free(tl->revert.icon1);
		tl->revert.icon1 = NULL;
	}

	if (tl->revert.icon2) {
		g_free(tl->revert.icon2);
		tl->revert.icon2 = NULL;
	}
*/
	if (tl->options.command) {
		g_free(tl->options.command); 
		tl->options.command = NULL;
	}

	if (tl->options.tooltip) {
		g_free(tl->options.tooltip); 
		tl->options.tooltip = NULL;
	}

	if (tl->options.icon1) {
		g_free(tl->options.icon1);
		tl->options.icon1 = NULL;
	}

	if (tl->options.icon2) {
		g_free(tl->options.icon2);
		tl->options.icon2 = NULL;
	}

}

static void
tl_free (Control * control)
{
    t_tl *tl = control->data;

    g_return_if_fail(tl != NULL);
    
    free_optionsdialog(tl);

    if (tl->timeout_handle) {
    	g_source_remove (tl->timeout_handle);
    	tl->timeout_handle = 0;
    }

    g_free(tl);
}

static void
tl_attach_callback (Control * control, const char *signal,
                       GCallback callback, gpointer data)
{
    t_tl *tl = control->data;

    g_signal_connect (tl->launcher, signal, callback, data);
}


G_MODULE_EXPORT void
tl_set_size (Control *control, int size)
{
	t_tl	*tl = (t_tl *)control->data;
	
	/* size: 0..3(HUGE), with 4- taken as huge too */

	gtk_widget_set_size_request(GTK_WIDGET(tl->launcher), icon_size[size], icon_size[size]);
}


/*  Mixer panel control
 *  -------------------
*/
gboolean
create_tl_control (Control * control)
{
	GtkWidget *alignment;
	t_tl *tl = NULL;
	
	if (!tooltips) {
		tooltips = gtk_tooltips_new();
	}
	
	tl = tl_new ();
	
	alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	gtk_container_add (GTK_CONTAINER (alignment), GTK_WIDGET(tl->hbox));
	gtk_widget_show (alignment);

	gtk_container_add (GTK_CONTAINER (control->base), alignment);

	control->data = (gpointer) tl;
	control->with_popup = FALSE;

	gtk_widget_set_size_request (control->base, -1, -1);

	g_signal_connect(tl->launcher, "clicked", G_CALLBACK(xfce_tl_launch_button_cb), tl);

	update_state(tl);

	return TRUE;
}

#if 0
static void
create_options_backup(t_tl *tl)
{
	tl->revert.command = g_strdup(tl->options.command); 
	tl->revert.tooltip = g_strdup(tl->options.tooltip);
	tl->revert.icon1 = g_strdup(tl->options.icon1);
	tl->revert.icon2 = g_strdup(tl->options.icon2);
	tl->revert.timeout = tl->options.timeout;
}
#endif

static GtkWidget *
tl_options_get(GtkContainer *c, int index)
{
	GList	*list;
	GList	*iter;
	int	pos = 0;
	GtkWidget *w = NULL;
	list = gtk_container_get_children(GTK_CONTAINER(c));
	if (!list) {
		return NULL;
	}
	
	w = GTK_WIDGET(list->data);
	for(iter = list; pos <= index && iter; iter = g_list_next(iter), pos++) {
		w = GTK_WIDGET(iter->data);
	}
	g_list_free(list);
	return w;
}

#if 0
static void 
tl_revert_make_sensitive_cb(GtkWidget *w, gpointer data)  /* verified prototype: clicked */
{
	gtk_widget_set_sensitive (w, TRUE);
}
#endif

/*static void 
tl_stuff_toggled_cb(GtkToggleButton *tb, t_tl *tl)  verified prototype: toggled
{
	tl_revert_make_sensitive_cb(tl->revert_b, NULL);
}*/

static void
tl_timeout_toggled_cb(GtkToggleButton *tb, t_tl *tl)
{
	gboolean act;
	GtkWidget *r_timeout;
	GtkWidget *h_timeout;
	
	h_timeout = tl_options_get(GTK_CONTAINER (tl->settings_c), 7);
	r_timeout = tl_options_get(GTK_CONTAINER (h_timeout), 1);
	
	act = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(tb));
	gtk_widget_set_sensitive (GTK_WIDGET (r_timeout), act);
}

static gboolean
tl_timeout_entry_value_changed_cb(GtkSpinButton *w, t_tl *tl) /* verified prototype: focus-out-event */
{
	return TRUE;
}

#if 0
static gboolean
tl_command_entry_lost_focus_cb(GtkWidget *w, GdkEvent *event, t_tl *tl) /* verified prototype: focus-out-event */
{
	tl_revert_make_sensitive_cb(tl->revert_b, NULL);
	return TRUE;
	/* FALSE;*/ /* needed? */
}
#endif

static void
tl_do_options(t_tl *tl, int mode) /* 0: load; 1: store;  */
{
	char const *temp;
	GtkContainer *c;
	GtkContainer *h1; /* hbox for entry */
/*	GtkContainer *h2;*/ /* hbox for vbox2 */
/*	GtkContainer *v2;*/ /* vbox for use_sn, use_terminal */
	GtkEntry	*e_command = NULL;	
	GtkButton	*b_dotdotdot = NULL;

	GtkEntry	*e_icon1 = NULL;
	GtkEntry	*e_icon2 = NULL;
	GtkEntry	*e_tooltip = NULL;
	GtkBox		*h_timeout = NULL;
	GtkWidget	*cb_timeout = NULL;
	GtkWidget	*r_timeout = NULL;
	double		v;
	gboolean	act_timeout;
	
	c = tl->settings_c; /* vbox 1 */

	if (c) {
		h1 = GTK_CONTAINER(tl_options_get(c, 0));
		e_command = GTK_ENTRY(tl_options_get(GTK_CONTAINER(h1), 1)); /* safe */
		b_dotdotdot = GTK_BUTTON(tl_options_get(GTK_CONTAINER(h1), 2)); /* safe */
/*		h2 = GTK_CONTAINER(tl_options_get(c, 1));*/
/*		v2 = GTK_CONTAINER(tl_options_get(h2, 1));
		b_use_term = GTK_CHECK_BUTTON(tl_options_get(v2, 0));
		b_use_sn = GTK_CHECK_BUTTON(tl_options_get(v2, 1));
*/
		e_icon1 = GTK_ENTRY(tl_options_get(
			GTK_CONTAINER(tl_options_get(
				GTK_CONTAINER(tl_options_get(
					c, 
				2)), 
			0)), 
		1));
		e_icon2 = GTK_ENTRY(tl_options_get(
			GTK_CONTAINER(tl_options_get(
				GTK_CONTAINER(tl_options_get(
					c, 
				3)), 
			0)), 
		1));
		
		e_tooltip = GTK_ENTRY(tl_options_get(
			GTK_CONTAINER(tl_options_get(
				c, 
			4)), 
		1));
		
		h_timeout = GTK_BOX(tl_options_get(c, 7));
		if (h_timeout) {
			cb_timeout = tl_options_get(GTK_CONTAINER (h_timeout), 0);
			r_timeout = tl_options_get(GTK_CONTAINER (h_timeout), 1);
			
			if (mode == 2) {
				g_signal_connect(GTK_WIDGET(cb_timeout), "toggled",
					G_CALLBACK(tl_timeout_toggled_cb),
					tl);
				g_signal_connect(GTK_WIDGET(r_timeout), "value-changed",
					G_CALLBACK(tl_timeout_entry_value_changed_cb),
					tl);
			}
		}
	}
	
	if (h_timeout && r_timeout) {
		switch (mode) {
		case 1:
			v = gtk_spin_button_get_value (GTK_SPIN_BUTTON (r_timeout));

			if (cb_timeout)
				act_timeout = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cb_timeout));
			else
				act_timeout = TRUE;
			
			if (!act_timeout) v = 0.0;
			tl->options.timeout = v;
			break;
		case 0:
			v = tl->options.timeout;
			act_timeout = (v != 0.0);
			
			if (cb_timeout)
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cb_timeout), act_timeout);
				
			gtk_widget_set_sensitive (GTK_WIDGET (r_timeout), act_timeout);
			if (!act_timeout) v = 0.0;
			gtk_spin_button_set_value (GTK_SPIN_BUTTON (r_timeout), v);
			break;
		
		}
	}

/*	if (b_dotdotdot && mode == 2) {
		g_signal_connect(GTK_WIDGET(b_dotdotdot), "clicked",
				G_CALLBACK(tl_revert_make_sensitive_cb),
				tl->revert_b);
	}
*/		
	if (e_command) {
		switch (mode) {
		case 1:
			temp = gtk_entry_get_text(GTK_ENTRY(e_command));
			if (temp && *temp) {
				tl->options.command = g_strdup(temp);
			}
			break;
		case 0:
			if (tl->options.command) {
				gtk_entry_set_text(GTK_ENTRY(e_command), g_strdup(tl->options.command));
			}
			break;
		case 2:
			/*g_signal_connect (e_command, "insert-at-cursor", G_CALLBACK (tl_revert_make_sensitive_cb), tl->revert_b);
			g_signal_connect_swapped (e_command, "delete-from-cursor", G_CALLBACK (tl_revert_make_sensitive_cb), tl->revert_b);
			*/
			/*g_signal_connect (e_command, "focus-out-event", G_CALLBACK(tl_command_entry_lost_focus_cb), tl);*/
			break;
		}
	}

	if (e_icon1) {
		switch (mode) {
		case 1:
			temp = gtk_entry_get_text(GTK_ENTRY(e_icon1));
			if (temp && *temp) {
				tl->options.icon1 = g_strdup(temp);
			}
			break;
		case 0:
			if (tl->options.icon1) {
				gtk_entry_set_text(GTK_ENTRY(e_icon1), g_strdup(tl->options.icon1));
			}
			break;
		}
	}

	if (e_icon2) {
		switch (mode) {
		case 1:
			temp = gtk_entry_get_text(GTK_ENTRY(e_icon2));
			if (temp && *temp) {
				tl->options.icon2 = g_strdup(temp);
			}
			break;
		case 0:
			if (tl->options.icon2) {
				gtk_entry_set_text(GTK_ENTRY(e_icon2), g_strdup(tl->options.icon2));
			}
			break;
		}
	}

	if (e_tooltip) {
		switch (mode) {
		case 1:
			temp = gtk_entry_get_text(GTK_ENTRY(e_tooltip));
			if (temp && *temp) {
				tl->options.tooltip = g_strdup(temp);
			}
			break;
		case 0:
			if (tl->options.tooltip) {
				gtk_entry_set_text(GTK_ENTRY(e_tooltip), g_strdup(tl->options.tooltip));
			}
			break;
		}
	}

}

static void
tl_apply_options_cb(GtkWidget *button, t_tl *tl) /* verified: clicked */
{
	if (tl->options.command) g_free(tl->options.command);
	tl->options.command = NULL;
	if (tl->options.tooltip) g_free(tl->options.tooltip);
	tl->options.tooltip = NULL;
	if (tl->options.icon1) g_free(tl->options.icon1);
	tl->options.icon1 = NULL;
	if (tl->options.icon2) g_free(tl->options.icon2);
	tl->options.icon2 = NULL;

	tl_do_options(tl, 1);
	
/*	if (!tl->revert.command || strcmp(tl->options.command, tl->revert.command)
	|| !tl->revert.icon1 || strcmp(tl->options.icon1, tl->revert.icon1)
	|| !tl->revert.icon2 || strcmp(tl->options.icon2, tl->revert.icon2)
	|| !tl->revert.tooltip || strcmp(tl->options.tooltip, tl->revert.tooltip)) {
		* changed command *
		tl->switched_on = launch_me(tl, TRUE);
		update_state(tl);
	}
*/	
	tl_timeout_changed (tl);
}	

static void
tl_fill_options(t_tl *tl)
{
	tl_do_options(tl, 0);
}

#if 0
static void
tl_revert_options_cb(GtkWidget *button, t_tl *tl) /* verified prototype: clicked */
{
	if (tl->options.icon1) g_free(tl->options.icon1);
	if (tl->options.icon2) g_free(tl->options.icon2);
	if (tl->options.tooltip) g_free(tl->options.tooltip);
	if (tl->options.command) g_free(tl->options.command);
	tl->options.command = NULL;
	tl->options.tooltip = NULL;
	tl->options.icon1 = NULL;
	tl->options.icon2 = NULL;
	
	tl->options.command = tl->revert.command;
	tl->options.tooltip = tl->revert.tooltip;
	tl->options.icon1 = tl->revert.icon1;
	tl->options.icon2 = tl->revert.icon2;
	tl->options.timeout = tl->revert.timeout;
	tl->revert.command = NULL;
	tl->revert.tooltip = NULL;
	tl->revert.icon1 = NULL;
	tl->revert.icon2 = NULL;
	
	tl_fill_options(tl);
	tl_timeout_changed (tl);
	create_options_backup(tl);
	gtk_widget_set_sensitive(tl->revert_b, FALSE);
}
#endif

#if 0
static GtkWidget *
my_create_command_option(GtkSizeGroup *sg)
{
	return create_command_option(w);
}
#else
/* this is for checking if that helps against Fuzzbox/Francois' reported bug */

/*  Change the command 
 *  ------------------
*/
static void
command_browse_cb (GtkWidget * b, GtkEntry * entry)
{
/*	GtkWidget	*h1 = NULL;
	GtkEntry	*entry = NULL;
	h1 = GTK_CONTAINER(tl_options_get(tl->settings_c, 0));
	entry = GTK_ENTRY(tl_options_get(GTK_CONTAINER(h1), 1));
*/	
    char *file =
        select_file_name (P_("Select command"), gtk_entry_get_text (entry),
                          gtk_widget_get_toplevel(GTK_WIDGET(entry)));

    if (file)
    {
        gtk_entry_set_text (entry, file);
        g_free (file);
    }
}

static GtkWidget *
my_create_command_option(GtkSizeGroup *sg)
{
    GtkWidget *vbox;
/*    GtkWidget *vbox2;*/
    GtkWidget *hbox;
    GtkWidget *hbox2;
    GtkWidget *label;
    GtkWidget *image;
    
    GtkWidget *command_entry = NULL;
    GtkWidget *command_browse_button = NULL;

    vbox = gtk_vbox_new (FALSE, 8);
    gtk_widget_show (vbox);

    /* entry */
    hbox = gtk_hbox_new (FALSE, 4);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);

    label = gtk_label_new (P_("Command:"));
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_size_group_add_widget (sg, label);
    gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

    command_entry = gtk_entry_new ();
    gtk_widget_show (command_entry);
    gtk_box_pack_start (GTK_BOX (hbox), command_entry, TRUE, TRUE, 0);

/*
    command_browse_button = gtk_button_new_from_stock (GTK_STOCK_OPEN);
*/

    command_browse_button = gtk_button_new(); /*_with_label ("...");*/

    image = gtk_image_new_from_stock(GTK_STOCK_OPEN, GTK_ICON_SIZE_BUTTON);
    gtk_widget_show(image);
    gtk_container_add(GTK_CONTAINER(command_browse_button), image);

    gtk_widget_show (command_browse_button);
    gtk_box_pack_start (GTK_BOX (hbox), command_browse_button, FALSE, FALSE, 0);
    
    g_signal_connect (command_browse_button, "clicked",
                      G_CALLBACK (command_browse_cb), command_entry);

    /* terminal */
    hbox2 = gtk_hbox_new (FALSE, 4);
    gtk_widget_show (hbox2);
    gtk_box_pack_start (GTK_BOX (vbox), hbox2, FALSE, TRUE, 0);

    label = gtk_label_new ("");
    gtk_size_group_add_widget (sg, label);
    gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);

/*    vbox2 = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox2);
    gtk_box_pack_start (GTK_BOX (hbox2), vbox2, FALSE, TRUE, 0);
*/

    return vbox;
}
#endif

static void
icon_browse_cb (GtkWidget * b, GtkEntry * entry)
{
	char *file =
		select_file_with_preview (
			P_("Select icon"), 
			gtk_entry_get_text (entry),
			gtk_widget_get_toplevel(GTK_WIDGET(entry)));
                                              
	if (file) {
		/*change_icon (EXTERN_ICON, file);*/
		gtk_entry_set_text(entry, g_strdup(file));
		/*tl_revert_make_sensitive_cb(tl->revert_b, NULL);*/
		g_free (file);
	}
}
                                                                          
static GtkWidget *
my_create_icon_option(GtkSizeGroup *sg, char const *which)
{
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *label;
    GtkWidget *icon_entry;
    GtkWidget *icon_browse_button;
    GtkWidget *image;

    vbox = gtk_vbox_new (FALSE, 8);
    gtk_widget_show (vbox);

    /* option menu */
/*
    hbox = gtk_hbox_new (FALSE, 4);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
    label = gtk_label_new (which);
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_size_group_add_widget (sg, label);
    gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
*/

/*    icon_id_menu = create_icon_option_menu ();
    gtk_widget_show (icon_id_menu);
    gtk_box_pack_start (GTK_BOX (hbox), icon_id_menu, TRUE, TRUE, 0);
*/

    /* icon entry */
    hbox = gtk_hbox_new (FALSE, 4);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);

    label = gtk_label_new (which);
    gtk_size_group_add_widget (sg, label);
    gtk_widget_show (label);
    gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);

    icon_entry = GTK_WIDGET(gtk_entry_new ());
    gtk_widget_show (icon_entry);
    gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET(icon_entry), TRUE, TRUE, 0);

/*    g_signal_connect (icon_entry, "focus-out-event",
                      G_CALLBACK (icon_entry_lost_focus), NULL);
*/

    icon_browse_button = gtk_button_new(); /*_with_label ("...");*/

    image = gtk_image_new_from_stock(GTK_STOCK_OPEN, GTK_ICON_SIZE_BUTTON);
    gtk_widget_show(image);

    gtk_container_add (GTK_CONTAINER (icon_browse_button), GTK_WIDGET (image));

    gtk_widget_show (icon_browse_button);
  gtk_box_pack_start (GTK_BOX (hbox), icon_browse_button, FALSE, FALSE, 0);

    g_signal_connect (icon_browse_button, "clicked",
                      G_CALLBACK (icon_browse_cb), icon_entry);

    return vbox;

}

static void
tl_create_options(Control *control, GtkContainer *container, GtkWidget *done)
{
	t_tl		*tl;
	GtkWidget 	*vbox, *vbox2, *vbox3;
	
	GtkWidget	*tooltip_hbox, *tooltip_entry, *tooltip_label;

	tl = (t_tl *)control->data;

	tl->dialog = gtk_widget_get_toplevel(done);
	
	tl->sg = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
	vbox = my_create_command_option(tl->sg);
	
	vbox2 = my_create_icon_option(tl->sg, _("Icon (off)"));
	vbox3 = my_create_icon_option(tl->sg, _("Icon (on)"));
	
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(vbox2), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(vbox3), FALSE, FALSE, 0);
	
	
	tooltip_hbox = GTK_WIDGET(gtk_hbox_new(FALSE, 5));
	gtk_widget_show(tooltip_hbox);
	
	tooltip_label = gtk_label_new(P_("Tooltip:"));
	tooltip_entry = gtk_entry_new();
	
	gtk_widget_show(tooltip_label);
	gtk_widget_show(tooltip_entry);
	
	gtk_box_pack_start(GTK_BOX(tooltip_hbox), GTK_WIDGET(tooltip_label), FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tooltip_hbox), GTK_WIDGET(tooltip_entry), FALSE, FALSE, 0);
	
	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(tooltip_hbox), FALSE, FALSE, 0);
	
/*	gtk_box_pack_start(GTK_BOX(vbox), GTK_WIDGET(relief_b), FALSE, FALSE, 0);*/
	
	gtk_container_add(GTK_CONTAINER(container), GTK_WIDGET(vbox));
	
	tl->settings_c = GTK_CONTAINER(vbox);
	tl_timeout_create_options (tl);


	tl_fill_options(tl);
	tl_do_options(tl, 2);
/*	create_options_backup(tl);*/
	
	g_signal_connect(GTK_WIDGET(tl->dialog), "destroy-event", G_CALLBACK(free_optionsdialog), tl);
	g_signal_connect(GTK_WIDGET(done), "clicked", G_CALLBACK(tl_apply_options_cb), tl);

}

extern xmlDocPtr xmlconfig;
#define MYDATA(node) xmlNodeListGetString(xmlconfig, node->children, 1)

static void
tl_read_config(Control *control, xmlNodePtr node)
{
/*	int	n;*/
	t_tl	*tl;
	xmlChar	*value;

	tl = (t_tl *)control->data;
	
	if (!node || !node->children) 
		return;
		
	node = node->children;
	
	if (!xmlStrEqual(node->name, (const xmlChar *)TWOSTATE_LAUNCHER_ROOT))
		return;
	for (node = node->children; node; node = node->next) {
		if (xmlStrEqual (node->name, (const xmlChar *)"Command")) {
			value = MYDATA (node);
			if (value) {
				if (tl->options.command) g_free (tl->options.command);
				tl->options.command = (char *)value;
			}
		}  else if (xmlStrEqual(node->name, (const xmlChar *)"IconOff")) {
			value = MYDATA(node);
			if (value) {
				if (tl->options.icon1) g_free(tl->options.icon1);
				tl->options.icon1 = (char *)value;
			}
		} else if (xmlStrEqual(node->name, (const xmlChar *)"IconOn")) {
			value = MYDATA(node);
			if (value) {
				if (tl->options.icon2) g_free(tl->options.icon2);
				tl->options.icon2 = (char *)value;
			}
		} else if (xmlStrEqual(node->name, (const xmlChar *)"Tooltip")) {
			value = MYDATA(node);
			if (value) {
				if (tl->options.tooltip) g_free(tl->options.tooltip);
				tl->options.tooltip = (char *)value;
			}
		} else if (xmlStrEqual(node->name, (const xmlChar *)"Timeout")) {
			value = MYDATA(node);
			if (value) {
				tl->options.timeout = atof(value);
				g_free (value);
				tl_timeout_changed (tl);
			}
		}
	}
	
	tl->switched_on = launch_me(tl, TRUE);
	update_state(tl);
}

static void
tl_write_config(Control *control, xmlNodePtr parent)
{
	xmlNodePtr root, node;
	char value[MAXSTRLEN + 1];

	t_tl *tl = (t_tl *) control->data;

	root = xmlNewTextChild (parent, NULL, TWOSTATE_LAUNCHER_ROOT, NULL);

	if (tl->options.command) {
		node = xmlNewTextChild (root, NULL, "Command", tl->options.command);
	}
	if (tl->options.icon1) {
		node = xmlNewTextChild (root, NULL, "IconOff", tl->options.icon1);
	}
	if (tl->options.icon2) {
		node = xmlNewTextChild (root, NULL, "IconOn", tl->options.icon2);
	}
	if (tl->options.tooltip) {
		node = xmlNewTextChild (root, NULL, "Tooltip", tl->options.tooltip);
	}
	
	sprintf(value, "%.1lf", tl->options.timeout);
	node = xmlNewTextChild (root, NULL, "Timeout", value);
}

G_MODULE_EXPORT void
xfce_control_class_init (ControlClass * cc)
{
#ifdef ENABLE_NLS
    /* This is required for UTF-8 at least - Please don't remove it */
    bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#ifdef HAVE_BIND_TEXTDOMAIN_CODESET
    bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#endif
    textdomain (GETTEXT_PACKAGE);
#endif

    cc->name = "tl";
    cc->caption = _("Two-state Launcher");

    cc->create_control = (CreateControlFunc) create_tl_control;

    cc->free = tl_free;
    cc->read_config = tl_read_config;
    cc->write_config = tl_write_config;
    cc->attach_callback = tl_attach_callback;
    
    cc->create_options = (gpointer) tl_create_options;

    cc->set_theme = tl_set_theme;

    cc->set_size = tl_set_size;
}

/* macro defined in plugins.h */
XFCE_PLUGIN_CHECK_INIT
