// -*- c++ -*-

/* modified by jha (j.habenicht@usa.net)
 */

// $Id: kpaint.h,v 1.40 2002/09/02 16:56:27 winkvist Exp $

#ifndef KPAINT_H
#define KPAINT_H

#include <qwidget.h>
#include <qscrollview.h>
#include <kmainwindow.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kstatusbar.h>
#include <ktempfile.h>

#include <qrect.h>
#include "canvas.h"
#include "manager.h"
#include "commands.h"
#include "navwidget.h"

#define ID_NAV_WIDGET 501
#define ID_COLORS_WIDGET 502
#define ID_COLOR_BAR 503

class MainView;
class KAction;
class KToggleAction;
class KSelectAction;
class NavWidget;
class KColorButton;
class KToolbar;

class KPaint : public KMainWindow
{
    Q_OBJECT

public:
    KPaint(const KURL & url_ = KURL());
    ~KPaint();

    void setPixmap(QPixmap *);

public slots:

    // File
    void fileNew();
    bool fileOpen();
    void fileClose();
    void fileRevert();
    bool fileSave();
    bool fileSaveAs();

    // Edit
    void editCopy();
    void editCut();
    void editPaste();
    void editPasteImage();
    void editClear();
    void editZoomNormal();
    void editZoomIn();
    void editZoomOut();
    void editOptions();
    void editToolbars();
    void editKeyBindings();

    //Edit Zoom
    void viewZoom( const QString & );

    // Image
    void imageInfo();
    void imageResize();
    void imageEditPalette();
    void imageChangeDepth();

    // Tool
    void toolProperties();
    void setTool(int);

    /**
    * Update toolbars/status bars etc.
    */
    void updateControls();
    void updateCommands();

    /**
    * Read the options
    */
    void readOptions();

    void enableEditPaste();

protected:
    // Load/Save files
    bool loadFile(const KURL& url);
    bool saveFile(QString filename_, QString format_, KURL &url_);

    /**
    * Should we really?
    */
    bool queryClose();

private:
    // Initialisation
    void initMenus();
    void initStatus();
    bool initSideBar();

    KAction *revertAction;
    KAction *copyAction;
    KAction *cutAction;
    KAction *pasteAction;
    KAction *paletteAction;
    KAction *saveAction;
    KAction *saveAsAction;
    KAction *pasteImageAction;
    KAction *zoomInAction;
    KAction *zoomOutAction;
    KAction *zoomNormalAction;

    KToggleAction *statusbarAction;
    KSelectAction *zoomAction;

    /**
     * Update status item
     */
    void canvasSizeChanged();

    
    // Info about the currently open image
    QString filename;          // actual local filename
    KURL url;                  // URL it came from
    QString format;            // format to use

    KTempFile *tmpFile;        // tempfile
    int zoom;

    // Command status
    bool allowEditPalette;

    // Tool manager
    Manager *man;

    // Navigation (preview) widget
    NavWidget *nav;
    // the color selection buttons    
    KColorButton *lmbColourBtn;
    KColorButton *rmbColourBtn;

    // Child widgets
    QScrollView *m_view;
    Canvas *m_canvas;

    KToolBar *toolsToolbar;
    KToolBar *commandsToolbar;
    KToolBar *sideToolbar;
  
    KStatusBar *statusbar;
    KMenuBar *menu;
    MainView *m_mainView;

    QPixmap *lmbColor, *rmbColor;
    int orig_width;
    int orig_height;
};

#endif
