#include <qpushbutton.h>
#include <qlabel.h>
#include <qframe.h>
#include <qkeycode.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qlayout.h>
#include <qevent.h>

#include <kaccel.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kiconloader.h>

#include "keys.h"
#include <klocale.h>
#include <kconfig.h>

Keys::Keys( QWidget *parent, const char *name, int player)
    : KDialogBase( parent, name, true, i18n("Change Direction Keys"),
    KDialogBase::Ok|KDialogBase::Cancel|KDialogBase::Default, KDialogBase::Ok, true )
{
    QWidget *page = new QWidget( this );
    QGridLayout *layout = new QGridLayout(page, 7, 7, marginHint(), 0);
    setMainWidget(page);

    playerNum = player;

    connect( this, SIGNAL(okClicked()), SLOT(ok()) );
    connect( this, SIGNAL(defaultClicked()), SLOT(defaults()) );

    for ( int x = 0; x < 4; x++) {
	labels[x] = new QLabel(page);
	labels[x]->setAlignment(AlignCenter);
	labels[x]->setFixedSize(100, labels[x]->sizeHint().height()+2);
    }

    QPushButton *up = new QPushButton(page);
    up->setPixmap( BarIcon("up"));
    up->setFixedSize(up->sizeHint() );
    connect( up, SIGNAL(clicked()),this, SLOT(butUp()) );

    QPushButton *down = new QPushButton(page);
    down->setPixmap( BarIcon("down"));
    down->setFixedSize(down->sizeHint() );
    connect( down, SIGNAL(clicked()),this, SLOT(butDown()) );

    QPushButton *left = new QPushButton(page);
    left->setPixmap( BarIcon("back"));
    left->setFixedSize(left->sizeHint() );
    connect( left, SIGNAL(clicked()),this, SLOT(butLeft()) );

    QPushButton *right = new QPushButton(page);
    right->setPixmap( BarIcon("forward"));
    right->setFixedSize(right->sizeHint() );
    connect( right, SIGNAL(clicked()),this, SLOT(butRight()) );

    layout->addMultiCellWidget(labels[0], 0, 0, 2, 4, AlignCenter);
    layout->addMultiCellWidget(labels[1], 6, 6, 2, 4, AlignCenter);
    layout->addWidget(labels[2], 3, 1, AlignCenter);
    layout->addWidget(labels[3], 3, 5, AlignCenter);
    layout->addWidget(up, 2, 3);
    layout->addWidget(down, 4, 3);
    layout->addWidget(left, 3, 2);
    layout->addWidget(right, 3, 4);

    layout->setRowStretch(0, 1);
    layout->addRowSpacing(1, spacingHint());
    layout->addRowSpacing(5, spacingHint());
    layout->setRowStretch(6, 1);
    layout->setColStretch(0, 1);
    layout->setColStretch(6, 1);
    lab = 0;
    init();
}

void Keys::keyPressEvent( QKeyEvent *e )
{
	uint kCode = e->key() & ~(SHIFT | CTRL | ALT);
	QString string = KKey(kCode).toString();

	if (lab != 0) {
	    if ( string.isNull() )
		lab->setText(i18n("Undefined key"));
	    else lab->setText(string);
	}
	else if ( lab == 0 && e->key() == Key_Escape)
	    reject();
}

void Keys::butUp()
{
    getKey(0);
}

void Keys::butDown()
{
    getKey(1);
}

void Keys::butLeft()
{
    getKey(2);
}

void Keys::butRight()
{
    getKey(3);
}

void Keys::getKey(int i)
{
    if ( lab != 0)
	focusOut(lab);

    focusIn(labels[i]);
}

void Keys::focusOut(QLabel *l)
{
    l->setFocusPolicy(NoFocus); 
    l->setFrameStyle( QFrame::NoFrame );
    l->setBackgroundColor(backgroundColor());
    l->repaint();
}

void Keys::focusIn(QLabel *l)
{
    lab = l;
    lab->setFocusPolicy(ClickFocus); 
    lab->setFocus(); 
    lab->setFrameStyle( QFrame::Panel | QFrame::Sunken );
    lab->setBackgroundColor(white);
    lab->repaint();
}

void Keys::defaults()
{
    if ( lab != 0)
	focusOut(lab);

    lab = 0;

    labels[0]->setText(i18n("Up"));
    labels[1]->setText(i18n("Down"));
    labels[2]->setText(i18n("Left"));
    labels[3]->setText(i18n("Right"));
}

void Keys::init()
{
    KConfig *conf = kapp->config();
    if(conf != NULL) {
		QString up = conf->readEntry(QString("upKey") + QString::number(playerNum), i18n("Up"));
	labels[0]->setText(up);

		QString down = conf->readEntry(QString("downKey") + QString::number(playerNum), i18n("Down"));
	labels[1]->setText(down);

		QString left = conf->readEntry(QString("leftKey") + QString::number(playerNum), i18n("Left"));
	labels[2]->setText(left);

		QString right = conf->readEntry(QString("rightKey") + QString::number(playerNum), i18n("Right"));
	labels[3]->setText(right);
    }
}

void Keys::ok()
{
    KConfig *conf = kapp->config();
    if(conf != NULL) {
		conf->writeEntry(QString("upKey") + QString::number(playerNum),   labels[0]->text() );
		conf->writeEntry(QString("downKey") + QString::number(playerNum), labels[1]->text() );
		conf->writeEntry(QString("leftKey") + QString::number(playerNum), labels[2]->text() );
		conf->writeEntry(QString("rightKey") + QString::number(playerNum),labels[3]->text() );
    }

    accept();
}

#include "keys.moc"
