/***************************************************************************
                           xmlwriter.cpp  -  description
                             -------------------
    begin                : Tue Feb 12 2002
    copyright            : (C) 2002 by Scott Wheeler
    email                : wheeler@kde.org
***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
***************************************************************************/

#include "xmlwriter.h"

XMLWriter::XMLWriter(QFile *output)
{
  outputFile = output;
  if(outputFile->open(IO_WriteOnly))
    {
      outputStream.setDevice(outputFile);
      outputStream.setEncoding(QTextStream::UnicodeUTF8);
      
      outputStream << "<?xml version=\"1.0\"?>" << endl;
      outputStream << "<!DOCTYPE kvtml SYSTEM \"kvoctrain.dtd\">" << endl;
      outputStream << "<kvtml>" << endl;
    }  
}

void XMLWriter::addItem(const QString &front, const QString &back)
{
  outputStream << " <e>" << endl;
  outputStream << "  <o>" << front << "</o>" << endl;
  outputStream << "  <t>" << back << "</t>" << endl;
  outputStream << " </e>" << endl;
}

XMLWriter::~XMLWriter()
{
  outputStream << "</kvtml>" << endl; 
  outputFile->close();
}
