/***************************************************************************
                            QPixmap.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QPIXMAP_H
#define QPIXMAP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QPaintDevice.h>
#include <qtobjc/Qt.h>
#include <qtobjc/QSize.h>
#include <qtobjc/QColor.h>

@class QImage;
@class QWMatrix;

@class QBitmap; 
@class QByteArray; 
@class QPoint; 
@class QRect; 

@interface QPixmap : Qt 
- init;
- initWithImage: (QImage *)image;
- initWithInt: (int)w h: (int)h depth: (int)depth int: (int)arg1;
- initWithInt: (int)w h: (int)h ;
- initWithSize: (QSize *)arg1 depth: (int)depth int: (int)arg2;
- initWithSize: (QSize *)arg1 ;
- initWithText: (NSString *)fileName format: (NSString *)format mode: (int)mode;
- initWithText: (NSString *)fileName ;
- initWithText: (NSString *)fileName format: (NSString *)format conversion_flags: (int)conversion_flags;
- initWithXpm: (char **)xpm;
- initWithByteArray: (QByteArray*)data;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;
- (BOOL) isNull;
- (int) width;
- (int) height;
- (QSize*) size;
- (QRect*) rect;
- (int) depth;
- fill: (QColor *)fillColor;
- fill;
- fill: (QWidget *)arg1 xofs: (int)xofs yofs: (int)yofs;
- fill: (QWidget *)arg1 ofs: (QPoint*)ofs;
- resize: (int)width height: (int)height;
- resize: (QSize *)arg1;
- (QBitmap*) mask;
- setMask: (QBitmap *)arg1;
- (BOOL) selfMask;
- (QBitmap*) createHeuristicMask: (BOOL)clipTight;
- (QBitmap*) createHeuristicMask;
- (QPixmap*) xForm: (QWMatrix *)arg1;
- (QImage*) convertToImage;
- (BOOL) convertFromImage: (QImage *)arg1 mode: (int)mode;
- (BOOL) convertFromImage: (QImage *)arg1 ;
- (BOOL) convertFromImage: (QImage *)arg1 conversion_flags: (int)conversion_flags;
- (BOOL) load: (NSString *)fileName format: (NSString *)format mode: (int)mode;
- (BOOL) load: (NSString *)fileName ;
- (BOOL) load: (NSString *)fileName format: (NSString *)format conversion_flags: (int)conversion_flags;
- (BOOL) loadFromData: (unsigned char*)buf len: (unsigned int)len format: (NSString *)format mode: (int)mode;
- (BOOL) loadFromData: (unsigned char*)buf len: (unsigned int)len ;
- (BOOL) loadFromData: (unsigned char*)buf len: (unsigned int)len format: (NSString *)format conversion_flags: (int)conversion_flags;
- (BOOL) loadFromData: (QByteArray*)data format: (NSString *)format conversion_flags: (int)conversion_flags;
- (BOOL) loadFromData: (QByteArray*)data ;
- (BOOL) save: (NSString *)fileName format: (NSString *)format quality: (int)quality;
- (BOOL) save: (NSString *)fileName format: (NSString *)format ;
//- (void*) hbm;
- (int) serialNumber;
- (int) optimization;
- setOptimization: (int)arg1;
- detach;
- (BOOL) isQBitmap;
//- (BOOL) isMultiCellPixmap;
//- (void*) multiCellHandle;
//- (void*) multiCellBitmap;
//- (int) multiCellOffset;
//- (int) allocCell;
//- freeCell: (BOOL)arg1;
//- freeCell;
//- (QGfx*) graphicsContext: (BOOL)clip_children;
//- (QGfx*) graphicsContext;
//- (unsigned char*) scanLine: (int)arg1;
//- (int) bytesPerLine;
//- (int*) clut;
//- (int) numCols;
//- x11SetScreen: (int)screen;
+ (int) defaultDepth;
+ (QPixmap*) grabWindow: (unsigned int)arg1 x: (int)x y: (int)y w: (int)w h: (int)h;
+ (QPixmap*) grabWindow: (unsigned int)arg1 ;
+ (QPixmap*) grabWidget: (QWidget *)widget x: (int)x y: (int)y w: (int)w h: (int)h;
+ (QPixmap*) grabWidget: (QWidget *)widget ;
+ (QWMatrix*) trueMatrix: (QWMatrix *)arg1 w: (int)w h: (int)h;
+ (NSString *) imageFormat: (NSString *)fileName;
+ (int) defaultOptimization;
+ setDefaultOptimization: (int)arg1;
+ (int) x11SetDefaultScreen: (int)screen;
- initWithInt: (int)w h: (int)h data: (unsigned char*)data isXbitmap: (BOOL)isXbitmap;
- (int) metric: (int)arg1;
+ (int) Auto;
+ (int) Color;
+ (int) Mono;
+ (int) DefaultOptim;
+ (int) NoOptim;
+ (int) MemoryOptim;
+ (int) NormalOptim;
+ (int) BestOptim;
@end

@class QGfx; 
@class QPoint; 
@class QRect; 

@class QBitmap; 
@class QByteArray; 
@class QPoint; 
@class QRect; 

@interface QPixmap (QPaintDeviceImplementation) <QPaintDeviceInterface>
@end

#endif
