/***************************************************************************
                            KFontChooser.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 While KFontChooser as an ordinary widget can be embedded in
 custom dialogs and therefore is very flexible, in most cases
 it is preferable to use the convenience functions in
 {@link KFontDialog}.

 See {@link KFontChooserSignals} for signals emitted by KFontChooser.

 

 @author Preston Brown <pbrown@kde.org>, Bernd Wuebben <wuebben@kde.org>

 @version $Id: KFontChooser.java,v 1.8 2002/11/26 04:17:32 rdale Exp $
 
 @short A font selection widget.

*/
public class KFontChooser extends QWidget  {
	protected KFontChooser(Class dummy){super((Class) null);}

	private native void newKFontChooser( QWidget parent, String name, boolean onlyFixed, String[] fontList, boolean makeFrame, int visibleListSize, boolean diff, int sizeIsRelativeState);

/** 
 Constructs a font picker widget.
 It normally comes up with all font families present on the system; the
 getFont method below does allow some more fine-tuning of the selection of fonts
 that will be displayed in the dialog.
 <p>Consider the following code snippet;<pre>

    StringList list;
    KFontChooser.getFontList(list,SmoothScalableFonts);
    KFontChooser chooseFont = new KFontChooser(0, "FontList", false, list);
 </pre>
 <p>The above creates a font chooser dialog with only SmoothScaleble fonts.

*/
	public KFontChooser( QWidget parent, String name, boolean onlyFixed, String[] fontList, boolean makeFrame, int visibleListSize, boolean diff, int sizeIsRelativeState) {
		super((Class) null);
		newKFontChooser( parent, name, onlyFixed, fontList, makeFrame, visibleListSize, diff, sizeIsRelativeState);
	}
	private native void newKFontChooser();
	public KFontChooser() {
		super((Class) null);
		newKFontChooser();
	}

/** 
 Destructs the font chooser.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Enables or disable a font column in the chooser.

 Use this
 function if your application does not need or supports all font
 properties.

*/
	public native void enableColumn( int column, boolean state);

/** 
 Sets the currently selected font in the chooser.

*/
	public native void setFont( QFont font, boolean onlyFixed);
	public native void setFont( QFont font);

/** 

*/
	public native int fontDiffFlags();

/** 

*/
	public native QFont font();

/** 
 Sets the color to use in the preview.
   
*/
	public native void setColor( QColor col);

/** 

*/
	public native QColor color();

/** 
 Sets the background color to use in the preview.
   
*/
	public native void setBackgroundColor( QColor col);

/** 

*/
	public native QColor backgroundColor();

/** 
 Sets the state of the checkbox indicating whether the font size
 is to be interpreted as relative size.
 NOTE: If parameter sizeIsRelative was not set in the constructor
       of the widget this setting will be ignored.
   
*/
	public native void setSizeIsRelative( int relative);

/** 

*/
	public native int sizeIsRelative();

/** 

*/
	public native String sampleText();

/** 
 Sets the sample text.

 Normally you should not change this
 text, but it can be better to do this if the default text is
 too large for the edit area when using the default font of your
 application.

*/
	public native void setSampleText( String text);

/** 
 Reimplemented for internal reasons.
   
*/
	public native QSize sizeHint();

/** 
 Converts a {@link QFont} into the corresponding X Logical Font
 Description (XLFD).

*/
	public static native String getXLFD( QFont theFont);

/** 
 Creates a list of font strings.

*/
	public static native void getFontList( String[] list, int fontListCriteria);
	protected native void virtual_hook( int identifier, int data);
	public static final int FamilyList = 0x01;
	public static final int StyleList = 0x02;
	public static final int SizeList = 0x04;
	public static final int FontDiffFamily = 0x01;
	public static final int FontDiffStyle = 0x02;
	public static final int FontDiffSize = 0x04;
	public static final int FixedWidthFonts = 0x01;
	public static final int ScalableFonts = 0x02;
	public static final int SmoothScalableFonts = 0x04;
}
