/***************************************************************************
                            kde_KProcIO.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPROCIO
#define KDE_KPROCIO

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 KProcIO

 This class provides a slightly simpler interface to the communication
  functions provided by KProcess.  The simplifications are:

 Basically, KProcIO gives you buffered I/O similar to fgets()/fputs().

 Aside from these, and the fact that start() takes different
 parameters, use this class just like @ref KProcess.

 @author David Sweet

 @version $Id: kde_KProcIO.h,v 1.4 2002/11/25 12:24:34 rdale Exp $

 @short A slightly simpler interface to KProcess.
*/
kde_KProcIO * kde_new_KProcIO(qt_QTextCodec* codec);
void kde_del_KProcIO( kde_KProcIO* p );

/** *
  Starts the process. It will fail in the following cases:

*/
int kde_KProcIO_start(kde_KProcIO* instPointer,int runmode, int includeStderr);

/** *
 Writes text to stdin of the process.

*/
int kde_KProcIO_writeStdin(kde_KProcIO* instPointer,qt_QString * line, int appendnewline);

/** *
 Writes text to stdin of the process.

*/
int kde_KProcIO_writeStdin1(kde_KProcIO* instPointer,qt_QCString* line, int appendnewline);

/** *
 Writes data to stdin of the process.

*/
int kde_KProcIO_writeStdin2(kde_KProcIO* instPointer,qt_QByteArray* data);

/** *
 This function just calls @ref writeStdin().

*/
int kde_KProcIO_fputs(kde_KProcIO* instPointer,qt_QString * line, int AppendNewLine);

/** *
 closes stdin after all data has been send.
   
*/
void kde_KProcIO_closeWhenDone(kde_KProcIO* instPointer);

/** *
 Reads a line of text (up to and including '\n').

 Use readln() in response to a readReady() signal.
 You may use it multiple times if more than one line of data is
  available.
 Be sure to use ackRead() when you have finished processing the
  readReady() signal.  This informs KProcIO that you are ready for
  another readReady() signal.

 readln() never blocks.

 autoAck==TRUE makes these functions call ackRead() for you.

*/
int kde_KProcIO_readln(kde_KProcIO* instPointer,qt_QString * line, int autoAck, int* partial);

/** *
 This function calls @ref readln().

*/
int kde_KProcIO_fgets(kde_KProcIO* instPointer,qt_QString * line, int autoAck);

/** *
 Reset the class.  Doesn't kill the process.

*/
void kde_KProcIO_resetAll(kde_KProcIO* instPointer);

/** *
 Call this after you have finished processing a readReady()
 signal.  This call need not be made in the slot that was signalled
 by readReady().  You won't receive any more readReady() signals
 until you acknowledge with ackRead().  This prevents your slot
 from being reentered while you are still processing the current
 data.  If this doesn't matter, then call ackRead() right away in
 your readReady()-processing slot.

*/
void kde_KProcIO_ackRead(kde_KProcIO* instPointer);

/** *
  Turns @ref readReady() signals on and off.
   You can turn this off at will and not worry about losing any data.
   (as long as you turn it back on at some point...)

*/
void kde_KProcIO_enableReadSignals(kde_KProcIO* instPointer,int enable);
void kde_KProcIO_controlledEmission(kde_KProcIO* instPointer);
void kde_KProcIO_virtual_hook(kde_KProcIO* instPointer,int identifier, void* data);
void kde_KProcIO_received(kde_KProcIO* instPointer,kde_KProcess* proc, char* buffer, int buflen);
void kde_KProcIO_sent(kde_KProcIO* instPointer,kde_KProcess* arg1);

#endif
