/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2003 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * preferences.c - load and save program settings
 */


#ifdef HAVE_CONFIG_H
#	include <config.h>
#endif
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "preferences.h"
#include "types.h"
#include "utils.h"

preferencestype preferences;
extern gchar *xlogdir;


void
loadpreferences (void)
{
  gchar *preferencesfile, label[100], value[100];
  FILE *fp;
  GString *sdir = g_string_new ("");

  /* defaults */
  preferences.version = "0.0";
  preferences.x = 10;
  preferences.y = 30;
  preferences.width = 750;
  preferences.height = 540;
  preferences.latitude = 0.0;
  preferences.NS = 1;
  preferences.longitude = 0.0;
  preferences.EW = 1;
  preferences.units = 1;
  preferences.bands = "1.8,3.5,7,10,14,18,21,24,28";
  preferences.modes = "CW,SSB,PSK31,MFSK,MT63,SSTV";
  preferences.bandseditbox = 0;
  preferences.modeseditbox = 0;
  preferences.printall = 0;
  preferences.printsize = 0;
  preferences.printpoint = 0;
  preferences.printstyle = 0;
  preferences.printdestination = 0;
  preferences.hamlib = 0;
  preferences.radio = "Dummy";
  preferences.device = "/dev/ttyS1";
  preferences.round = 0;
  preferences.clock = 0;
  preferences.themecolor = "0000,0000,cd00";
  preferences.themefont = "-adobe-helvetica-bold-r-*-*-*-120-*-*-*-*-*-*";
  preferences.logcolor = 1;
  preferences.autosave = 5;
  g_string_sprintf (sdir, "%s.", G_DIR_SEPARATOR_S);
  g_string_append (sdir, PACKAGE);
  preferences.savedir = g_strconcat (g_get_home_dir (), sdir->str, NULL);
  preferences.saving = 1;
  preferences.logstoload = "*";
  preferences.locator = "AA00AA";
  preferences.freefield1 = "UNKNOWN";
  preferences.freefield2 = "UNKNOWN";
  preferences.callsign = "N0CALL";
  preferences.defaultmhz = "?";
  preferences.defaultmode = "?";
  preferences.defaulttxrst = "?";
  preferences.defaultrxrst = "?";
  preferences.defaultpower = "?";
  preferences.defaultfreefield1 = "?";
  preferences.defaultfreefield2 = "?";
  preferences.defaultremarks = "?";
  preferences.b4columns = g_strdup("1,1,1,1,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0");
  preferences.typeaheadfind = 1;
  preferences.remoteadding = 1;
  g_string_free (sdir, TRUE);

  /* open preferences file */
  preferencesfile =
    g_strconcat (xlogdir, G_DIR_SEPARATOR_S, "preferences", NULL);
  fp = fopen (preferencesfile, "r");

  if (fp != NULL)
    {
      /* read preferences file */
      while (!feof (fp))
	{
	  if (fscanf (fp, "%s %s", label, value) == EOF)
	    break;
	  if (!g_strcasecmp (label, "version"))
	    preferences.version = g_strdup (value);
	  else if (!g_strcasecmp (label, "x"))
	    preferences.x = atoi (value);
	  else if (!g_strcasecmp (label, "y"))
	    preferences.y = atoi (value);
	  else if (!g_strcasecmp (label, "width"))
	    preferences.width = atoi (value);
	  else if (!g_strcasecmp (label, "height"))
	    preferences.height = atoi (value);
	  else if (!g_strcasecmp (label, "latitude"))
	    preferences.latitude = atof (value);
	  else if (!g_strcasecmp (label, "NS"))
	    preferences.NS = atoi (value);
	  else if (!g_strcasecmp (label, "longitude"))
	    preferences.longitude = atof (value);
	  else if (!g_strcasecmp (label, "EW"))
	    preferences.EW = atoi (value);
	  else if (!g_strcasecmp (label, "units"))
	    preferences.units = atoi (value);
	  else if (!g_strcasecmp (label, "bands"))
	    preferences.bands = g_strdup (value);
	  else if (!g_strcasecmp (label, "modes"))
	    preferences.modes = g_strdup (value);
	  else if (!g_strcasecmp (label, "modeseditbox"))
	    preferences.modeseditbox = atoi (value);
	  else if (!g_strcasecmp (label, "bandseditbox"))
	    preferences.bandseditbox = atoi (value);
	  else if (!g_strcasecmp (label, "printall"))
	    preferences.printall = atoi (value);
	  else if (!g_strcasecmp (label, "printsize"))
	    preferences.printsize = atoi (value);
	  else if (!g_strcasecmp (label, "printpoint"))
	    preferences.printpoint = atoi (value);
	  else if (!g_strcasecmp (label, "printdestination"))
	    preferences.printdestination = atoi (value);
	  else if (!g_strcasecmp (label, "printstyle"))
	    preferences.printstyle = atoi (value);
	  else if (!g_strcasecmp (label, "hamlib"))
	    preferences.hamlib = atoi (value);
	  else if (!g_strcasecmp (label, "radio"))
	    {
	      preferences.radio = g_strdup (value);
	      g_strdelimit (preferences.radio, "_", ' ');
	    }
	  else if (!g_strcasecmp (label, "device"))
	    {
	      preferences.device = g_strdup (value);
	      g_strdelimit (preferences.device, "_", ' ');
	    }
	  else if (!g_strcasecmp (label, "round"))
	    preferences.round = atoi (value);
	  else if (!g_strcasecmp (label, "clock"))
	    preferences.clock = atoi (value);
	  else if (!g_strcasecmp (label, "themecolor"))
	    preferences.themecolor = g_strdup (value);
	  else if (!g_strcasecmp (label, "themefont"))
	    {
	      preferences.themefont = g_strdup (value);
	      g_strdelimit (preferences.themefont, "_", ' ');

	    }
	  else if (!g_strcasecmp (label, "logcolor"))
	    preferences.logcolor = atoi (value);
	  else if (!g_strcasecmp (label, "autosave"))
	    preferences.autosave = atoi (value);
	  else if (!g_strcasecmp (label, "savedir"))
	    preferences.savedir = g_strdup (value);
	  else if (!g_strcasecmp (label, "saving"))
	    preferences.saving = atoi (value);
	  else if (!g_strcasecmp (label, "logstoload"))
	    preferences.logstoload = g_strdup (value);
	  else if (!g_strcasecmp (label, "locator"))
	    preferences.locator = g_strdup (value);
	  else if (!g_strcasecmp (label, "freefield1"))
	    {
	      preferences.freefield1 = g_strdup (value);
	      g_strdelimit (preferences.freefield1, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "freefield2"))
	    {
	      preferences.freefield2 = g_strdup (value);
	      g_strdelimit (preferences.freefield2, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "callsign"))
	    preferences.callsign = g_strdup (value);
	  else if (!g_strcasecmp (label, "defaultmhz"))
	    {
	      preferences.defaultmhz = g_strdup (value);
	      g_strdelimit (preferences.defaultmhz, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "defaultmode"))
	    {
	      preferences.defaultmode = g_strdup (value);
	      g_strdelimit (preferences.defaultmode, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "defaulttxrst"))
	    {
	      preferences.defaulttxrst = g_strdup (value);
	      g_strdelimit (preferences.defaulttxrst, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "defaultrxrst"))
	    {
	      preferences.defaultrxrst = g_strdup (value);
	      g_strdelimit (preferences.defaultrxrst, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "defaultpower"))
	    {
	      preferences.defaultpower = g_strdup (value);
	      g_strdelimit (preferences.defaultmode, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "defaultfreefield1"))
	    {
	      preferences.defaultfreefield1 = g_strdup (value);
	      g_strdelimit (preferences.defaultfreefield1, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "defaultfreefield2"))
	    {
	      preferences.defaultfreefield2 = g_strdup (value);
	      g_strdelimit (preferences.defaultfreefield2, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "defaultremarks"))
	    {
	      preferences.defaultremarks = g_strdup (value);
	      g_strdelimit (preferences.defaultremarks, "~", ' ');
	    }
	  else if (!g_strcasecmp (label, "b4columns"))
	      preferences.b4columns = g_strdup (value);
	  else if (!g_strcasecmp (label, "typeaheadfind"))
	    preferences.typeaheadfind = atoi (value);
	  else if (!g_strcasecmp (label, "remoteadding"))
	    preferences.remoteadding = atoi (value);
	}
      fclose (fp);
    }
  g_free (preferencesfile);
}

void
savepreferences (void)
{
  gchar *preferencesfile, *temp;
  FILE *fp;

  /* open preferences file */
  preferencesfile =
    g_strconcat (xlogdir, G_DIR_SEPARATOR_S, "preferences", NULL);
  fp = fopen (preferencesfile, "w");
  if (fp != NULL)
    {
      /* warning and version */
      fprintf (fp, "# settings file for %s, do not edit\n", PACKAGE);
      fprintf (fp, "version %s\n", VERSION);
      temp = g_strdup_printf ("%d", preferences.x);
      fprintf (fp, "x %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.y);
      fprintf (fp, "y %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.width);
      fprintf (fp, "width %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.height);
      fprintf (fp, "height %s\n", temp);
      temp = g_strdup_printf ("%3.2f", preferences.latitude);
      fprintf (fp, "latitude %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.NS);
      fprintf (fp, "NS %s\n", temp);
      temp = g_strdup_printf ("%3.2f", preferences.longitude);
      fprintf (fp, "longitude %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.EW);
      fprintf (fp, "EW %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.units);
      fprintf (fp, "units %s\n", temp);
      temp = g_strdup (preferences.bands);
      fprintf (fp, "bands %s\n", temp);
      temp = g_strdup (preferences.modes);
      fprintf (fp, "modes %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.modeseditbox);
      fprintf (fp, "modeseditbox %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.bandseditbox);
      fprintf (fp, "bandseditbox %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.printall);
      fprintf (fp, "printall %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.printsize);
      fprintf (fp, "printsize %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.printpoint);
      fprintf (fp, "printpoint %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.printstyle);
      fprintf (fp, "printstyle %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.printdestination);
      fprintf (fp, "printdestination %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.hamlib);
      fprintf (fp, "hamlib %s\n", temp);
      temp = g_strdup (preferences.radio);
      g_strdelimit (temp, " ", '_');	/* can't save spaces */
      fprintf (fp, "radio %s\n", temp);
      temp = g_strdup (preferences.device);
      g_strdelimit (temp, " ", '_');	/* can't save spaces */
      fprintf (fp, "device %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.round);
      fprintf (fp, "round %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.clock);
      fprintf (fp, "clock %s\n", temp);
      temp = g_strdup (preferences.themecolor);
      fprintf (fp, "themecolor %s\n", temp);
      temp = g_strdup (preferences.themefont);
      g_strdelimit (temp, " ", '_');	/* can't save spaces */
      fprintf (fp, "themefont %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.logcolor);
      fprintf (fp, "logcolor %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.autosave);
      fprintf (fp, "autosave %s\n", temp);
      temp = g_strdup (preferences.savedir);
      fprintf (fp, "savedir %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.saving);
      fprintf (fp, "saving %s\n", temp);
      temp = g_strdup (preferences.logstoload);
      fprintf (fp, "logstoload %s\n", temp);
      temp = g_strdup (preferences.locator);
      fprintf (fp, "locator %s\n", temp);
      temp = g_strdup (preferences.freefield1);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "freefield1 %s\n", temp);
      temp = g_strdup (preferences.freefield2);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "freefield2 %s\n", temp);
      temp = g_strdup (preferences.callsign);
      fprintf (fp, "callsign %s\n", temp);
      temp = g_strdup (preferences.defaultmhz);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "defaultmhz %s\n", temp);
      temp = g_strdup (preferences.defaultmode);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "defaultmode %s\n", temp);
      temp = g_strdup (preferences.defaulttxrst);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "defaulttxrst %s\n", temp);
      temp = g_strdup (preferences.defaultrxrst);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "defaultrxrst %s\n", temp);
      temp = g_strdup (preferences.defaultpower);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "defaultpower %s\n", temp);
      temp = g_strdup (preferences.defaultfreefield1);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "defaultfreefield1 %s\n", temp);
      temp = g_strdup (preferences.defaultfreefield2);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "defaultfreefield2 %s\n", temp);
      temp = g_strdup (preferences.defaultremarks);
      g_strdelimit (temp, " ", '~');	/* can't save spaces */
      fprintf (fp, "defaultremarks %s\n", temp);
      temp = g_strdup (preferences.b4columns);
      fprintf (fp, "b4columns %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.typeaheadfind);
      fprintf (fp, "typeaheadfind %s\n", temp);
      temp = g_strdup_printf ("%d", preferences.remoteadding);
      fprintf (fp, "remoteadding %s\n", temp);
      g_free (temp);
      fclose (fp);
    }
  g_free (preferencesfile);
}
