/***************************************************************************
                            KKey.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

public class  KKey implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KKey(Class dummy){}

	private native void newKKey();

/** 
 Creates a new null KKey.

*/
	public KKey() {
		newKKey();
	}
	private native void newKKey( int keyQt);

/** 
 Creates a new key for the given Qt key code.

*/
	public KKey( int keyQt) {
		newKKey( keyQt);
	}
	private native void newKKey( QKeySequence keySeq);

/** 
 Creates a new key from the first key code of the given key sequence.

*/
	public KKey( QKeySequence keySeq) {
		newKKey( keySeq);
	}
	private native void newKKey( QKeyEvent keyEvent);

/** 
 Extracts the key from the given key event.

*/
	public KKey( QKeyEvent keyEvent) {
		newKKey( keyEvent);
	}
	private native void newKKey( KKey key);

/** 
 Copy constructor.
	 
*/
	public KKey( KKey key) {
		newKKey( key);
	}
	private native void newKKey( String key);

/** 
 Creates a new key from the given description. The form of the description
 is "[modifier+[modifier+]]+key", for example "e", "CTRL+q" or 
 "CTRL+ALT+DEL". Allowed modifiers are "SHIFT", "CTRL", "ALT", "WIN" and
 "META". "WIN" and "META" are equivalent. Modifiers are not case-sensitive. 

*/
	public KKey( String key) {
		newKKey( key);
	}
	private native void newKKey( int key, int mod);

/** 

	 
*/
	public KKey( int key, int mod) {
		newKKey( key, mod);
	}
//	private native void newKKey( int key, int mod);

/**  @internal 
*/
//	public KKey( int key, int mod) {
//		newKKey( key, mod);
//	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Clears the key. The key is null after calling this function.

*/
	public native void clear();

/** 
 Initializes the key with the given Qt key code.

*/
	public native boolean init( int keyQt);

/** 
 Initializes the key with the first key code of the given key sequence.

*/
	public native boolean init( QKeySequence keySeq);

/** 
 Initializes the key by extracting the code from the given key event.

*/
	public native boolean init( QKeyEvent keyEvent);

/** 
 Copies the given key.

*/
	public native boolean init( KKey key);

/** 
 Initializes the key with the given description. The form of the description
 is "[modifier+[modifier+]]+key", for example "e", "CTRL+q" or 
 "CTRL+ALT+DEL". Allowed modifiers are "SHIFT", "CTRL", "ALT", "WIN" and
 "META". "WIN" and "META" are equivalent. Modifiers are not case-sensitive. 

*/
	public native boolean init( String arg1);

/** 

	 
*/
	public native boolean init( int key, int mod);

/** 
 Returns true if the key is null (after {@link #clear} or empty
 constructor).

*/
	public native boolean isNull();

/** 

	 
*/
	public native boolean isValidQt();

/** 

	 
*/
	public native boolean isValidNative();

/** 

	 
*/
	public native int sym();

/** 

	 
*/
	public native int modFlags();

/** 
 Compares this key with the given KKey object. Returns a negative 
 number if the given KKey is larger, 0 if they are equal and
 a positive number this KKey is larger. The returned value
 is the difference between the symbol or, if the symbols 
 are equal, the difference between the encoded modifiers.

*/
	public native int compare( KKey key);

/** 
 Returns the qt key code.

*/
	public native int keyCodeQt();

/** 
 Returns a human-readable representation of the key in the form
 "modifier+key".

*/
	public native String toString();

/** 

	 
*/
	public native String toStringInternal();

/** 

	 
*/
	public native void simplify();

/** 
 Returns a null key.

*/
	public static native KKey nullKey();

/** 
 Returns a user-readable representation of the given modifiers.

*/
	public static native String modFlagLabel( int f);
	public static final int MOD_FLAG_COUNT = 4;
	public static final int QtWIN = (Qt.ALT<<1);
	public static final int SHIFT = 0x01;
	public static final int CTRL = 0x02;
	public static final int ALT = 0x04;
	public static final int WIN = 0x08;
}
