/*****************************************************************

Copyright (c) 1996-2002 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <klocale.h>
#include <kglobal.h>
#include <kapplication.h>
#include <kiconloader.h>

#include "prefmenu.h"

K_EXPORT_KICKER_MENUEXT(prefmenu, PrefMenu)


PrefMenu::PrefMenu(QWidget *parent, const char *name,
                   const QStringList &/*args*/)
  : PanelServiceMenu( QString::null, QString( "Settings/" ), parent, name)
{
}

PrefMenu::~PrefMenu()
{
}

void PrefMenu::initialize() 
{
  if(initialized())
     return;
  

  insertItem(SmallIconSet("kcontrol"), i18n("Control Center"),
               this, SLOT(slotLaunchControlCenter()));
  insertSeparator();

  // now initialize the menu itself
  doInitialize();

  setInitialized(true);
}

void PrefMenu::slotLaunchControlCenter() {
  KApplication::startServiceByDesktopName("kcontrol", QStringList(), 
                                          0, 0, 0, "", true);
}

void PrefMenu::reload()
{
	initialize();
}

#include "prefmenu.moc"
