/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __panelbuttonbase_h__
#define __panelbuttonbase_h__

#include <qbutton.h>
#include <qcursor.h>
#include <qguardedptr.h>
#include <qimage.h>
#include <qpixmap.h>

#include <kiconloader.h>
#include <kurl.h>

#include "global.h"

class PanelButtonBase : public QButton
{
    Q_OBJECT

public:
    PanelButtonBase(QWidget *parent=0, const char *name=0,  WFlags f=0 );

    bool isValid() { return _valid; }
    void setTile(const QString&);
    void setIcon(const QString&);
    void setIconURL(const KURL & url);
    void setBackground();
    void setTitle(const QString&);

    void setDrawArrow(bool);

    QString title() const { return _title; }
    QString icon() const { return _iconName; }
    Orientation orientation() const { return _orientation; }
    Direction popupDirection() const { return _popupDirection; }
    QPoint center() const { return mapToGlobal(rect().center()); }
    virtual QPixmap labelIcon() const; 
    virtual QPixmap zoomIcon() const { return _iconz; }

    static void setZoomEnabled(bool b);

signals:
    void iconChanged();

public slots:
    void slotSetOrientation(Orientation o) { _orientation = o; }
    void slotSetPopupDirection(Direction d);
    void slotMovieUpdate(const QRect&);
    void slotMovieStatus(int);

protected slots:
    void slotSettingsChanged(int);

protected:
    virtual void resizeEvent(QResizeEvent*);
    virtual void drawButton(QPainter *);
    virtual void drawButtonLabel(QPainter *);
    virtual void enterEvent(QEvent *);
    virtual void leaveEvent(QEvent *);
    virtual void dragEnterEvent(QDragEnterEvent *);
    virtual void dragLeaveEvent(QDragLeaveEvent *);
    virtual void dropEvent(QDropEvent *);
    virtual QString defaultIcon() const { return "unknown"; };

    void setArrowDirection(Position dir);
    void loadTiles();
    void loadIcons();
    bool calculateIconSizes();

    bool _drawArrow;
    bool _highlight;
    bool _animated;
    bool _changeCursorOverItem;
    bool _hasAcceptedDrag;
    bool _hasAnimation;
    bool _valid;
    QString _tile;
    QString _title;
    QString _iconName;
    QPixmap _up;
    QPixmap _down;
    QPixmap _bg;
    QPixmap _icon;
    QPixmap _iconh;
    QPixmap _iconz;
    QMovie *_movie;
    Position _arrowDirection;
    Direction _popupDirection;
    Orientation _orientation;
    KIcon::StdSizes _size;
    KIcon::StdSizes _zoom_size;
};

class ZoomButton : public PanelButtonBase
{
    Q_OBJECT

public:
    ZoomButton();
    ~ZoomButton();
    bool isZoomingEnabled() const { return zooming; }
    bool isAnimationEnabled() const { return doAnimations; }
    bool isWatching( PanelButtonBase* btn );
    void watchMe( PanelButtonBase* btn );
    void unFocus();

public slots:
    void reconfigure();
    void updateIcon();

protected:
    void drawButtonLabel(QPainter *p, const QPixmap &bg);
    bool eventFilter( QObject *o, QEvent * e);
    // reimp these to do nothing
    void resizeEvent(QResizeEvent*) {};
    void enterEvent( QEvent*) {}
    void leaveEvent( QEvent*) {}
    void unsetCursor();
    void readAnimatedIconsConfig();

    QEvent* locked;
    QGuardedPtr<PanelButtonBase> watch;
    QCursor _oldCursor;
    QPoint mypos;
    bool zooming;
    bool doAnimations;
    int hideTimer;
};


#endif // __panelbuttonbase_h__

