#
# -- START --
# $Id: postinstall.bsdi.sh,v 1.4 2001/12/12 01:54:49 papowell Exp papowell $
# 
# This is the shell script that does the postinstall
# dynamic fixup
#  It needs to be massaged with the information for
#  various paths.
# If you are building a package,  then you do NOT want
#  to have this executed - it will put the sample files
#  in place.  You need to do this during the postinstall
#  step in the package installation.
#

echo RUNNING postinstall.bsdi MAKEPACKAGE="$MAKEPACKAGE" MAKEINSTALL="$MAKEINSTALL" PREFIX="$PREFIX" cwd `pwd`
if [ "$VERBOSE_INSTALL" != "" ] ; then set -x; fi
fix () {
	v=`echo $1 | sed -e 's/[:;].*//'`;
	p=`echo $2 | sed -e 's/[:;].*//'`; d=`dirname $p`;
	if expr "$p" : "\|" >/dev/null ; then
		echo "$v is a filter '$p'" 
		exit 0
	fi
	echo "Checking for $v.sample in $d"
	if [ ! -d "$d" ] ; then
		echo "Directory $d does not exist!"
		mkdir -p $d
	fi
	if [ -f $v.sample ] ; then
		if [ $v.sample != $p.sample ] ; then cp $v.sample $p.sample; fi
	elif [ -f $v ] ; then
		if [ $v != $p.sample ] ; then cp $v $p.sample; fi
	else
		echo "Do not have $v.sample or $v"
	fi
	if [ ! -f $p.sample ] ; then
		echo "Do not have $p.sample"
	else 
		if [ -f $p ] ; then
			date=`date | awk '{ print $6, $2, $3, $4;}' | sed -e 's/  */_/g' `
			echo "Saving $p in $p.$date"
			mv $p $p.$date
		fi
		chmod 644 $p.sample
		cp $p.sample $p;
		chmod 644 $p;
	fi;
}
# we use the /usr/local/etc/rc.d method to start
# lpd
echo "Installing configuration file"
fix ifhp.conf "${DESTDIR}${IFHP_CONF}"
exit 0
