/*     
 **********************************************************************
 *     sblive_fx.c
 *     Copyright 1999, 2000 Creative Labs, Inc. 
 * 
 ********************************************************************** 
 * 
 *     Date                 Author          Summary of changes 
 *     ----                 ------          ------------------ 
 *     October 20, 1999     Bertrand Lee    base code release 
 * 
 ********************************************************************** 
 * 
 *     This program is free software; you can redistribute it and/or 
 *     modify it under the terms of the GNU General Public License as 
 *     published by the Free Software Foundation; either version 2 of 
 *     the License, or (at your option) any later version. 
 * 
 *     This program is distributed in the hope that it will be useful, 
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of 
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *     GNU General Public License for more details. 
 * 
 *     You should have received a copy of the GNU General Public 
 *     License along with this program; if not, write to the Free 
 *     Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, 
 *     USA. 
 * 
 ********************************************************************** 
 */

#include "hwaccess.h"
#include "efxmgr.h"

int sblive_fxInit(struct sblive_hw *sb_hw)
{
	int i;
	u32 z, w, x, y, pc = 16;

	for (i = 0; i < 512; i++) 
	{
		WRITE_EFX(sb_hw, i * 2, 0x10040);
		WRITE_EFX(sb_hw, i * 2 + 1, 0x610040);
	}

	for (i = 0; i < 256; i++)
	  sblive_writeptr(sb_hw, FXGPREGBASE + i, 0, 0);

	w = 0x40;
	x = 1;
	y = 0x44;
	z = 0x101;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (4 << 20) | (z << 10) | w);
	++pc;

	w = 0x101;
	x = 0x115;
	y = 0x11;
	z = 0x101;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (0 << 20) | (z << 10) | w);
	++pc;

	w = 0x101;
	x = 0x113;
	y = 0x13;
	z = 0x101;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (0 << 20) | (z << 10) | w);
	++pc;

	w = 0x101;
	x = 0x40;
	y = 0x40;
	z = 0x21;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	z = 0x23;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x40;
	y = 0x40;
	z = 0x25;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	z = 0x27;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x111;
	y = 0x101;
	z = 0x29;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (0 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x11;
	y = 0x40;
	z = 0x2B;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0;
	y = 0x44;
	z = 0x100;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (4 << 20) | (z << 10) | w);
	++pc;

	w = 0x100;
	x = 0x114;
	y = 0x10;
	z = 0x100;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (0 << 20) | (z << 10) | w);
	++pc;

	w = 0x100;
	x = 0x112;
	y = 0x12;
	z = 0x100;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (0 << 20) | (z << 10) | w);
	++pc;

	w = 0x100;
	x = 0x40;
	y = 0x40;
	z = 0x20;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	z = 0x22;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x40;
	y = 0x40;
	z = 0x24;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	z = 0x26;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x110;
	y = 0x100;
	z = 0x28;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (0 << 20) | (z << 10) | w);
	++pc;

	w = 0x40;
	x = 0x10;
	y = 0x40;
	z = 0x2A;
	WRITE_EFX(sb_hw, pc * 2, (x << 10) | y);
	WRITE_EFX(sb_hw, pc * 2 + 1, (6 << 20) | (z << 10) | w);
	++pc;

	sblive_writeptr(sb_hw, DBG, 0, 0);

	return CTSTATUS_SUCCESS;
}

/* FIXME: We should probably be doing something here */
int sblive_fxExit(struct sblive_hw *sb_hw)
{
	return CTSTATUS_SUCCESS;
}
