%{
/**
    This file is part of KMathTool, a KDE program for the math class...
    Copyright (C) 2002 Dominique Devriese <fritmebufstek@pandora.be>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <qcstring.h>
#include "parser.h"
#include "nodes.h"
#define YYSTYPE FormulaNode*
#include "bison_parser.tab.hpp"
#define YY_INPUT( buf, result, max_size ) \
Parser::instance()->yyinput( buf, result, max_size);

%}

%option noyywrap

DIGIT [0-9]


%%

"x"	{
	yylval = new VariableNode;
	return VAR;
	}

{DIGIT}+	{
		int i = atoi( yytext );
		yylval = new ConstantNode( static_cast<double>( i ) );
		return NUM;
		}
{DIGIT}*"."{DIGIT}+	{
			double d;
			sscanf( yytext, "%lf", &d );
			yylval = new ConstantNode( d );
			return NUM;
			}

{DIGIT}*","{DIGIT}+	{
			double d;
			sscanf( yytext, "%lf", &d );
			yylval = new ConstantNode( d );
			return NUM;
			}
[[:blank:]] /* skip spaces and tabs... */
.	{
	return yytext[0];
	}
\n	{
	return '\n';
	}
	
%%
/* to prevent a warning about yyunput() not being used:*/
inline void nonsenseFunction()
{
	yyunput(0,0);
};
