/***************************************************************************
                          areaperimeter1.cpp  -  description
                             -------------------
    begin                : Son Apr 14 2002
    copyright            : (C) 2002 by Birgit Schulz
    email                : B.Schulz@Superlehrer.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "areaperimeter1.h"
#include "areaperimeter1.moc"

#include <math.h>

#include <qlabel.h>
#include <qpixmap.h>

#include <kcombobox.h>
#include <krestrictedline.h>
#include <kapplication.h>
#include <klocale.h>

#include "rectangle.xpm"
#include "square.xpm"
#include "circle.xpm"


AreaPerimeter1::AreaPerimeter1(QWidget *parent, const char *name ) : AreaPerimeter1D(parent,name)
{
	m_apoKRestrictedLineInfo[0] = KRestrictedLineInfo1;
	m_apoKRestrictedLineInfo[1] = KRestrictedLineInfo2;
	m_apoKRestrictedLineInfo[2] = KRestrictedLineInfo3;
	m_apoKRestrictedLineInfo[3] = KRestrictedLineInfo4;
	m_apoKRestrictedLineInfo[4] = KRestrictedLineInfo5;
	m_apoKRestrictedLineInfo[5] = KRestrictedLineInfo6;
	m_apoKRestrictedLineInfo[6] = KRestrictedLineInfo7;
	m_apoKRestrictedLineInfo[7] = KRestrictedLineInfo8;
	m_apoTextLabelInfo[0] = TextLabelInfo1;
	m_apoTextLabelInfo[1] = TextLabelInfo2;
	m_apoTextLabelInfo[2] = TextLabelInfo3;
	m_apoTextLabelInfo[3] = TextLabelInfo4;
	m_apoTextLabelInfo[4] = TextLabelInfo5;
	m_apoTextLabelInfo[5] = TextLabelInfo6;
	m_apoTextLabelInfo[6] = TextLabelInfo7;
	m_apoTextLabelInfo[7] = TextLabelInfo8;

}

AreaPerimeter1::~AreaPerimeter1()
{
}

void AreaPerimeter1::changeView(EFunctions eSelected)
{
    //Lschen aller Eingabe-Felder
    for (int i = 0; i < MAX_RESTRICTED_LINES; i++)
    {
        m_apoKRestrictedLineInfo[i]->setText("");
    }
    TextLabelWarning->hide();

    switch (eSelected)
    {
        case Square:
        {
            const QPixmap imageSquare( const_cast<const char**>(square));
            PixmapLabel->setPixmap(imageSquare);

            TextLabelInformation->setText(i18n("Area and perimeter of a square"));
            TextLabelInfo1->setText(i18n("Side-length  a ="));
            TextLabelInfo2->setText(i18n("Area  A ="));
            TextLabelInfo3->setText(i18n("Perimeter  U ="));
            TextLabelInfo4->setText(i18n("Diagonal  d ="));

            //Einstellen der Items in der Combo-Box
            KComboBoxFunctionSelected->clear();
            KComboBoxFunctionSelected->insertItem(i18n("Side-Length a"));
            KComboBoxFunctionSelected->insertItem(i18n("Area A"));
            KComboBoxFunctionSelected->insertItem(i18n("Perimeter U"));
            KComboBoxFunctionSelected->insertItem(i18n("Diagonal d"));

            //Einstellen der ersten Funktion in der Combo-Box
            for (int i = 0; i < 4; i++)
            {
                m_apoKRestrictedLineInfo[i]->setEnabled(false);
                m_apoKRestrictedLineInfo[i]->show();
                m_apoTextLabelInfo[i]->show();
            }
            KRestrictedLineInfo1->setEnabled(true);

            //Verstecken der unbenutzten Felder und Label
            for (int i = 4; i < MAX_RESTRICTED_LINES; i++)
            {
                m_apoKRestrictedLineInfo[i]->hide();
                m_apoTextLabelInfo[i]->hide();
            }

            m_eSelected = Square;
            break;

        }

        case Rectangle:
        {
            const QPixmap imageRectangle( const_cast<const char**>(rectangle_xpm));
            PixmapLabel->setPixmap(imageRectangle);
            //Einstellen der verwendeten TextLabel
            TextLabelInformation->setText(i18n("Area and perimeter of a rectangle"));
            TextLabelInfo1->setText(i18n("Side-length  a ="));
            TextLabelInfo2->setText(i18n("Side-length  b ="));
            TextLabelInfo3->setText(i18n("Area  A ="));
            TextLabelInfo4->setText(i18n("Perimeter  U ="));
            TextLabelInfo5->setText(i18n("Diagonal  d ="));
            TextLabelInfo5->setEnabled(true);

            //Einstellen der Combo-Box
            KComboBoxFunctionSelected->clear();
            KComboBoxFunctionSelected->insertItem(i18n("Two Side-Lengths a & b"));
            KComboBoxFunctionSelected->insertItem(i18n("Side-Length a & Area A"));
            KComboBoxFunctionSelected->insertItem(i18n("Side-Length a & Perimeter U"));
            KComboBoxFunctionSelected->insertItem(i18n("Side-Length a & Diagonal d"));
            KComboBoxFunctionSelected->insertItem(i18n("Side-Length b & Area A"));
            KComboBoxFunctionSelected->insertItem(i18n("Side-Length b & Perimeter U"));
            KComboBoxFunctionSelected->insertItem(i18n("Side-Length b & Diagonal d"));
            KComboBoxFunctionSelected->insertItem(i18n("Area A & Perimeter U"));
            KComboBoxFunctionSelected->insertItem(i18n("Area A & Diagonal d"));
            KComboBoxFunctionSelected->insertItem(i18n("Perimeter U & Diagonal d"));

            //Einstellen der ersten Funktion in der Combo-Box
            for (int i = 0; i < 5; i++)
            {
                m_apoKRestrictedLineInfo[i]->setEnabled(false);
                m_apoKRestrictedLineInfo[i]->show();
                m_apoTextLabelInfo[i]->show();
            }
            KRestrictedLineInfo1->setEnabled(true);
            KRestrictedLineInfo2->setEnabled(true);


            //Einstellen der unbenutzten Felder und Label
            for (int i = 5; i < MAX_RESTRICTED_LINES; i++)
            {
                m_apoKRestrictedLineInfo[i]->hide();
                m_apoTextLabelInfo[i]->hide();
            }

            m_eSelected = Rectangle;

            break;

        }

        case Circle:
        {
            const QPixmap imageCircle( const_cast<const char**>(circle));
            PixmapLabel->setPixmap(imageCircle);

            TextLabelInformation->setText(i18n("Area and perimeter of a circle"));
            TextLabelInfo1->setText(i18n("Radius  r ="));
            TextLabelInfo2->setText(i18n("Diameter  d ="));
            TextLabelInfo3->setText(i18n("Area  A ="));
            TextLabelInfo4->setText(i18n("Perimeter  U ="));

            //Einstellen der Items in der Combo-Box
            KComboBoxFunctionSelected->clear();
            KComboBoxFunctionSelected->insertItem(i18n("Radius  r"));
            KComboBoxFunctionSelected->insertItem(i18n("Diameter  d"));
            KComboBoxFunctionSelected->insertItem(i18n("Area  A"));
            KComboBoxFunctionSelected->insertItem(i18n("Perimeter U"));

            //Einstellen der ersten Funktion in der Combo-Box
            for (int i = 0; i < 4; i++)
            {
                m_apoKRestrictedLineInfo[i]->setEnabled(false);
                m_apoKRestrictedLineInfo[i]->show();
                m_apoTextLabelInfo[i]->show();
            }
            KRestrictedLineInfo1->setEnabled(true);

            //Einstellen der unbenutzten Felder und Label
            for (int i = 4; i < MAX_RESTRICTED_LINES; i++)
            {
                m_apoKRestrictedLineInfo[i]->hide();
                m_apoTextLabelInfo[i]->hide();
            }

            m_eSelected = Circle;
            break;
        }
    }
}

void AreaPerimeter1::slotCalculate()
{
    //Was wurde in der Combo-Box eingestellt?
    int iSelected = KComboBoxFunctionSelected->currentItem();
    //Auswahl aufrgund von Formular-Aufruf-Art
    switch (m_eSelected)
    {
        //Quadrat*************************************************************************
        case Square:
        {
            QString qsSide, qsPerimeter, qsArea, qsDiagonal;
            double a,d,A,U;

            switch (iSelected)
            {
                case 0:
                {
                    qsSide = KRestrictedLineInfo1->text();
                    a = qsSide.toDouble();

                    A = a*a;
                    d = sqrt(2)*a;
                    U = 4*a;
                    
                    qsArea = qsArea.arg(A);
                    KRestrictedLineInfo2->setText(qsArea);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo3->setText(qsPerimeter);
                    qsDiagonal = qsDiagonal.arg(d);
                    KRestrictedLineInfo4->setText(qsDiagonal);
                }
                break;

                case 1:
                {
                    qsArea = KRestrictedLineInfo2->text();
                    A = qsArea.toDouble();
                    
                    a = sqrt(A);
                    d = sqrt(2)*a;
                    U = 4*a;
                    
                    qsSide=qsSide.arg(a);
                    KRestrictedLineInfo1->setText(qsSide);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo3->setText(qsPerimeter);
                    qsDiagonal = qsDiagonal.arg(d);
                    KRestrictedLineInfo4->setText(qsDiagonal);
                }
                break;

                case 2:
                {
                    qsPerimeter = KRestrictedLineInfo3->text();
                    U = qsPerimeter.toDouble();

                    a = U/4;
                    d = sqrt(2)*a;
                    A = a*a;

                    qsSide=qsSide.arg(a);
                    KRestrictedLineInfo1->setText(qsSide);
                    qsArea = qsArea.arg(A);
                    KRestrictedLineInfo2->setText(qsArea);
                    qsDiagonal = qsDiagonal.arg(d);
                    KRestrictedLineInfo4->setText(qsDiagonal);

                }
                break;

                case 3:
                {
                    qsDiagonal = KRestrictedLineInfo4->text();
                    d = qsDiagonal.toDouble();

                    a = d/sqrt(2);
                    A = a*a;
                    U = 4*a;
                    
                    qsSide=qsSide.arg(a);
                    KRestrictedLineInfo1->setText(qsSide);
                    qsArea = qsArea.arg(A);
                    KRestrictedLineInfo2->setText(qsArea);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo3->setText(qsPerimeter);
                }
                break;
            }
            break;
        }

        case Rectangle: //Rechteck***************************************************************
        {
            QString qsSide1,qsSide2, qsPerimeter, qsArea, qsDiagonal;
            double a,b,d,A,U;
            switch (iSelected)
            {
                case 0:
                {
                    qsSide1 = KRestrictedLineInfo1->text();
                    a = qsSide1.toDouble();
                    qsSide2 = KRestrictedLineInfo2->text();
                    b = qsSide2.toDouble();

                    A = a*b;
                    d = sqrt(a*a+b*b);
                    U = 2*a+2*b;
                    
                    qsArea = qsArea.arg(A);
                    KRestrictedLineInfo3->setText(qsArea);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo4->setText(qsPerimeter);
                    qsDiagonal = qsDiagonal.arg(d);
                    KRestrictedLineInfo5->setText(qsDiagonal);
                    break;
                }
                
                case 1:
                {
                    qsSide1 = KRestrictedLineInfo1->text();
                    a = qsSide1.toDouble();
                    qsArea = KRestrictedLineInfo3->text();
                    A = qsArea.toDouble();

                    b=A/a;
                    d = sqrt(a*a+b*b);
                    U = 2*a+2*b;

                    qsSide2 = qsSide2.arg(b);
                    KRestrictedLineInfo2->setText(qsSide2);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo4->setText(qsPerimeter);
                    qsDiagonal = qsDiagonal.arg(d);
                    KRestrictedLineInfo5->setText(qsDiagonal);
                    break;
                }
                
                case 2: //side-length a and perimeter U");
                {
                    qsSide1 = KRestrictedLineInfo1->text();
                    a = qsSide1.toDouble();
                    qsPerimeter = KRestrictedLineInfo4->text();
                    U = qsPerimeter.toDouble();

                    b=(U-2*a)/2;
                    d = sqrt(a*a+b*b);
                    A = a*b;
                    
                    qsSide2 = qsSide2.arg(b);
                    KRestrictedLineInfo2->setText(qsSide2);
                    qsArea = qsArea.arg(A);
                    KRestrictedLineInfo3->setText(qsArea);
                    qsDiagonal = qsDiagonal.arg(d);
                    KRestrictedLineInfo5->setText(qsDiagonal);
                    break;
                }
                
                case 3: //side-length a and diagonal d");
                {
                    qsSide1 = KRestrictedLineInfo1->text();
                    a = qsSide1.toDouble();
                    qsDiagonal = KRestrictedLineInfo5->text();
                    d = qsDiagonal.toDouble();
                    
                    if ((d-a)<0)
                    {
                        TextLabelWarning->setText(i18n("Warning: The given numbers do not\nequate to a regular rectangle!\nThe side a is too long."));
                        TextLabelWarning->show();
                        break;
                    }
                    else
                    {
                        b = sqrt(d*d-a*a);
                        A = a*b;
                        U = 2*a+2*b;
                        
                        qsSide2 = qsSide2.arg(b);
                        KRestrictedLineInfo2->setText(qsSide2);
                        qsArea = qsArea.arg(A);
                        KRestrictedLineInfo3->setText(qsArea);
                        qsPerimeter = qsPerimeter.arg(U);
                        KRestrictedLineInfo4->setText(qsPerimeter);
                        break;
                    }
                }
                
                case 4: //side-length b and area A");
                {
                    qsSide2 = KRestrictedLineInfo2->text();
                    b = qsSide2.toDouble();
                    qsArea = KRestrictedLineInfo3->text();
                    A = qsArea.toDouble();

                    a = A/b;
                    d = sqrt(a*a+b*b);
                    U = 2*a+2*b;
                    
                    qsSide1 = qsSide1.arg(a);
                    KRestrictedLineInfo1->setText(qsSide1);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo4->setText(qsPerimeter);
                    qsDiagonal = qsDiagonal.arg(d);
                    KRestrictedLineInfo5->setText(qsDiagonal);
                    break;
                }
                
                case 5: //side-length b and perimeter U");
                {
                    qsSide2 = KRestrictedLineInfo2->text();
                    b = qsSide2.toDouble();
                    qsPerimeter = KRestrictedLineInfo4->text();
                    U = qsPerimeter.toDouble();

                    a=(U-2*b)/2;
                    d = sqrt(a*a+b*b);
                    A = a*b;
                    
                    qsSide1 = qsSide1.arg(a);
                    KRestrictedLineInfo1->setText(qsSide1);
                    qsArea = qsArea.arg(A);
                    KRestrictedLineInfo3->setText(qsArea);
                    qsDiagonal = qsDiagonal.arg(d);
                    KRestrictedLineInfo5->setText(qsDiagonal);
                    break;
                }
                
                case 6: //side-length b and diagonal d");
                {
                    qsSide2 = KRestrictedLineInfo2->text();
                    b = qsSide2.toDouble();
                    qsDiagonal = KRestrictedLineInfo5->text();
                    d = qsDiagonal.toDouble();
                    
                    if ((d-b)<0)
                    {
                        TextLabelWarning->setText(i18n("Warning: The given numbers do not\nequate to a regular rectangle!\nThe side b is too long."));
                        TextLabelWarning->show();
                        break;
                    }
                    else
                    {
                        a = sqrt(d*d-b*b);
                        A = a*b;
                        U = 2*a+2*b;
                        
                        qsSide1 = qsSide1.arg(a);
                        KRestrictedLineInfo1->setText(qsSide1);
                        qsArea = qsArea.arg(A);
                        KRestrictedLineInfo3->setText(qsArea);
                        qsPerimeter = qsPerimeter.arg(U);
                        KRestrictedLineInfo4->setText(qsPerimeter);
                        break;
                    }
                }

                case 7: //area A and perimeter U");
                {
                    qsArea = KRestrictedLineInfo3->text();
                    A = qsArea.toDouble();
                    qsPerimeter = KRestrictedLineInfo4->text();
                    U = qsPerimeter.toDouble();
                    
                    if ((U*U/16-A)<0)
                    {
                        TextLabelWarning->setText(i18n("Warning: The given numbers do not\nequate to a regular rectangle!\nThe area A is too large."));
                        TextLabelWarning->show();
                        break;
                    }
                    else
                    {
                        a = U/4 + sqrt(U*U/16-A);
                        b = A/a;
                        d = sqrt(a*a+b*b);
                        
                        qsSide1 = qsSide1.arg(a);
                        KRestrictedLineInfo1->setText(qsSide1);
                        qsSide2 = qsSide2.arg(b);
                        KRestrictedLineInfo2->setText(qsSide2);
                        qsDiagonal = qsDiagonal.arg(d);
                        KRestrictedLineInfo5->setText(qsDiagonal);
                        break;
                    }
                }
                
                case 8: //Area A and diagonal d");
                {
                    qsArea = KRestrictedLineInfo3->text();
                    A = qsArea.toDouble();
                    qsDiagonal = KRestrictedLineInfo5->text();
                    d = qsDiagonal.toDouble();
                    
                    if ((d*d*d*d/4-A*A)<0)
                    {
                        TextLabelWarning->setText(i18n("Warning: The given numbers do not\nequate to a regular rectangle!\nThe area A is too large."));
                        TextLabelWarning->show();
                        break;
                    }
                    else
                    {
                        b = sqrt(d*d/2+sqrt(d*d*d*d/4-A*A));
                        a = A/b;
                        U = 2*(a+b);                    
                        
                        qsSide1 = qsSide1.arg(a);
                        KRestrictedLineInfo1->setText(qsSide1);
                        qsSide2 = qsSide2.arg(b);
                        KRestrictedLineInfo2->setText(qsSide2);
                        qsPerimeter = qsPerimeter.arg(U);
                        KRestrictedLineInfo4->setText(qsPerimeter);
                        break;
                    }
                }
                
                case 9: //perimeter U and diagonal d");
                {
                    qsPerimeter = KRestrictedLineInfo4->text();
                    U = qsPerimeter.toDouble();
                    qsDiagonal = KRestrictedLineInfo5->text();
                    d = qsDiagonal.toDouble();
                    
                    if ((d*d/2-U*U/16)<0)
                    {
                        TextLabelWarning->setText(i18n("Warning: The given numbers do not\nequate to a regular rectangle!\nThe perimeter U is too large."));
                        TextLabelWarning->show();
                        break;
                    }
                    else
                    {
                        b = U/4+sqrt(d*d/2-U*U/16);
                        
                        if ((U/2-b)<0)
                        {
                            TextLabelWarning->setText(i18n("Warning: The given numbers do not\nequate to a regular rectangle!\nThe perimeter U is too small."));
                            TextLabelWarning->show();
                            break;
                        }
                        else
                        {
                            a = U/2-b;
                            A = a*b;
                            
                            qsSide1 = qsSide1.arg(a);
                            KRestrictedLineInfo1->setText(qsSide1);
                            qsSide2 = qsSide2.arg(b);
                            KRestrictedLineInfo2->setText(qsSide2);
                            qsArea = qsArea.arg(A);
                            KRestrictedLineInfo3->setText(qsArea);
                            break;
                        }
                    }
                }
            break;
            }
        break;
        }
        
        case Circle:
        {
            QString qsRadius, qsDiameter, qsArea, qsPerimeter;
            double r,d,A,U;
            const double pi = 3.1412;

            switch (iSelected)
            {
                case 0:
                {
                    qsRadius = KRestrictedLineInfo1->text();
                    r = qsRadius.toDouble();

                    d = 2*r;
                    A = pi*r*r;
                    U = 2*pi*r;
                    
                    qsArea = qsArea.arg(A);
                    qsDiameter = qsDiameter.arg(d);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo2->setText(qsDiameter);
                    KRestrictedLineInfo3->setText(qsArea);
                    KRestrictedLineInfo4->setText(qsPerimeter);
                }
                break;
                
                case 1:
                {
                    qsDiameter = KRestrictedLineInfo2->text();
                    d = qsDiameter.toDouble();

                    r = d/2;
                    A = pi*r*r;
                    U = 2*pi*r;
                    
                    qsRadius = qsRadius.arg(r);
                    qsArea = qsArea.arg(A);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo1->setText(qsRadius);
                    KRestrictedLineInfo3->setText(qsArea);
                    KRestrictedLineInfo4->setText(qsPerimeter);
                }
                break;
                
                case 2:
                {
                    qsArea = KRestrictedLineInfo3->text();
                    A = qsArea.toDouble();

                    r = sqrt(A/pi);
                    d = 2*r;
                    U = 2*pi*r;
                    
                    qsRadius = qsRadius.arg(r);
                    qsDiameter = qsDiameter.arg(d);
                    qsPerimeter = qsPerimeter.arg(U);
                    KRestrictedLineInfo1->setText(qsRadius);
                    KRestrictedLineInfo2->setText(qsDiameter);
                    KRestrictedLineInfo4->setText(qsPerimeter);
                }
                break;
                
                case 3:
                {
                    qsPerimeter = KRestrictedLineInfo4->text();
                    U = qsPerimeter.toDouble();

                    r = U/(2*pi);
                    d = 2*r;
                    A = pi*r*r;
                    
                    qsRadius = qsRadius.arg(r);
                    qsArea = qsArea.arg(A);
                    qsDiameter = qsDiameter.arg(d);
                    KRestrictedLineInfo1->setText(qsRadius);
                    KRestrictedLineInfo2->setText(qsDiameter);
                    KRestrictedLineInfo3->setText(qsArea);
                }
                break;
            }
            break;
        }
    }
}



void AreaPerimeter1::slotClear()
{
	for (int i = 0; i < MAX_RESTRICTED_LINES; i++)
	{
		m_apoKRestrictedLineInfo[i]->setText("");
    }
    TextLabelWarning->hide();
}




void AreaPerimeter1::slotFunctionSelected(int iSelected)
{
	for (int i = 0; i < MAX_RESTRICTED_LINES; i++)
	{
		m_apoKRestrictedLineInfo[i]->setText("");
		m_apoKRestrictedLineInfo[i]->setEnabled(false);
    }
    TextLabelWarning->hide();

    switch (m_eSelected)
    {
        case Square:
        case Circle:
        {
            switch (iSelected)
            {
                case 0:
                {
                    KRestrictedLineInfo1->setEnabled(true);
                    break;
                }
                

        		case 1:
		        {
		            KRestrictedLineInfo2->setEnabled(true);
              		break;
		        }

		        case 2:
		        {
		            KRestrictedLineInfo3->setEnabled(true);
		            break;
		        }

		
		        case 3:
		        {
		            KRestrictedLineInfo4->setEnabled(true);
              		break;
		        }
			}
        }
        break;
        case Rectangle: //Rechteck*****************************************************
        {
            switch (iSelected)
            {
                case 0:
                {
                    KRestrictedLineInfo1->setEnabled(true);
                    KRestrictedLineInfo2->setEnabled(true);
                }
                break;
                
                case 1:
                {
                    KRestrictedLineInfo1->setEnabled(true);
                    KRestrictedLineInfo3->setEnabled(true);
                }
                break;
                
                case 2:
                {
                    KRestrictedLineInfo1->setEnabled(true);
                    KRestrictedLineInfo4->setEnabled(true);
                }
                break;
                
                case 3:
                {
                    KRestrictedLineInfo1->setEnabled(true);
                    KRestrictedLineInfo5->setEnabled(true);
                }
                break;
                
                case 4:
                {

                    KRestrictedLineInfo2->setEnabled(true);
                    KRestrictedLineInfo3->setEnabled(true);
                }
                break;
                
                case 5:
                {
                    KRestrictedLineInfo2->setEnabled(true);
                    KRestrictedLineInfo4->setEnabled(true);
                }
                break;
                
                case 6:
                {
                    KRestrictedLineInfo2->setEnabled(true);
                    KRestrictedLineInfo5->setEnabled(true);
                }
                break;
                
                case 7:
                {
                    KRestrictedLineInfo3->setEnabled(true);
                    KRestrictedLineInfo4->setEnabled(true);
                }
                break;
                
                case 8:
                {
                    KRestrictedLineInfo3->setEnabled(true);
                    KRestrictedLineInfo5->setEnabled(true);
                }
                break;
                
                case 9:
                {
                    KRestrictedLineInfo4->setEnabled(true);
                    KRestrictedLineInfo5->setEnabled(true);
                }
                break;
            }
        }
        break;
    }
}

void AreaPerimeter1::slotCheckBoxes(const QString &qsText)
{
   
}

