/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __PLUGIN_LOADER_H__
#define __PLUGIN_LOADER_H__

#include <qptrdict.h>

class KPanelApplet;
class KPanelExtension;
class AppletInfo;

class PluginLoader : public QObject
{
    Q_OBJECT

public:
    static PluginLoader* pluginLoader();

    KPanelApplet* loadApplet(
       const AppletInfo& info, QWidget* parent );
    KPanelExtension* loadExtension(
       const AppletInfo& info, QWidget* parent );
    bool hasInstance( const AppletInfo& ) const;

private slots:
    void slotPluginDestroyed( QObject* plugin );

public:
   PluginLoader();
   virtual ~PluginLoader();

private:
   QPtrDict<AppletInfo>  _dict;
};

class LibUnloader : public QObject
{
    Q_OBJECT
public:
    static void unload( const QString &libName );

private slots:
    void unload();

private:
    LibUnloader( const QString &libName, QObject *parent );

    QString _libName;
};

#endif
