#include "ksvmiscconfig.h"

#include <qgroupbox.h>
#include <qlayout.h>

#include <kdialog.h>

/* 
 *  Constructs a KSVMiscConfig which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
KSVMiscConfig::KSVMiscConfig( QWidget* parent,  const char* name, WFlags fl )
    : MiscConfiguration( parent, name, fl )
{
  mSpacer->setFixedHeight (KDialog::spacingHint());

  // Messages
  mMessagesBoxLayout->setMargin (KDialog::marginHint());
  mMessagesBoxLayout->setSpacing(KDialog::spacingHint());

//   // Editor
//   mEditorBoxLayout->setMargin (KDialog::marginHint());
//   mEditorBoxLayout->setSpacing (KDialog::spacingHint());
}

/*  
 *  Destroys the object and frees any allocated resources
 */
KSVMiscConfig::~KSVMiscConfig()
{
    // no need to delete child widgets, Qt does it all for us
}

#include "miscconfig.moc"
#include "ksvmiscconfig.moc"

