/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;

final class MultiplexInputStream
extends InputStream {
    private ConnectionMultiplexer manager;
    private MultiplexConnectionInfo info;
    private byte[] buffer;
    private int present = 0;
    private int pos = 0;
    private int requested = 0;
    private boolean disconnected = false;
    private Object lock = new Object();
    private int waterMark;
    private byte[] temp = new byte[1];

    MultiplexInputStream(ConnectionMultiplexer connectionMultiplexer, MultiplexConnectionInfo multiplexConnectionInfo, int n2) {
        this.manager = connectionMultiplexer;
        this.info = multiplexConnectionInfo;
        this.buffer = new byte[n2];
        this.waterMark = n2 / 2;
    }

    public synchronized int read() throws IOException {
        int n2 = this.read(this.temp, 0, 1);
        if (n2 != 1) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 <= 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pos >= this.present) {
                this.present = 0;
                this.pos = 0;
            } else if (this.pos >= this.waterMark) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.present - this.pos);
                this.present -= this.pos;
                this.pos = 0;
            }
            int n5 = this.buffer.length - this.present;
            n4 = Math.max(n5 - this.requested, 0);
        }
        if (n4 > 0) {
            this.manager.sendRequest(this.info, n4);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.requested += n4;
            while (this.pos >= this.present && !this.disconnected) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.disconnected && this.pos >= this.present) {
                return -1;
            }
            int n6 = this.present - this.pos;
            if (n3 < n6) {
                System.arraycopy(this.buffer, this.pos, byArray, n2, n3);
                this.pos += n3;
                return n3;
            }
            System.arraycopy(this.buffer, this.pos, byArray, n2, n6);
            this.present = 0;
            this.pos = 0;
            return n6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.present - this.pos;
        }
    }

    public void close() throws IOException {
        this.manager.sendClose(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receive(int n2, DataInputStream dataInputStream) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos > 0 && this.buffer.length - this.present < n2) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.present - this.pos);
                this.present -= this.pos;
                this.pos = 0;
            }
            if (this.buffer.length - this.present < n2) {
                throw new IOException("Receive buffer overflow");
            }
            dataInputStream.readFully(this.buffer, this.present, n2);
            this.present += n2;
            this.requested -= n2;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnected = true;
            this.lock.notifyAll();
        }
    }
}

