/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.nio.channels.spi.SelectorProvider;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.NativeThread;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;

class SourceChannelImpl
extends Pipe.SourceChannel
implements SelChImpl {
    private static NativeDispatcher nd;
    FileDescriptor fd;
    int fdVal;
    private volatile long thread = 0L;
    private final Object lock = new Object();
    private final Object stateLock = new Object();
    private static final int ST_UNINITIALIZED = -1;
    private static final int ST_INUSE = 0;
    private static final int ST_KILLED = 1;
    private volatile int state = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$sun$nio$ch$SourceChannelImpl;

    public FileDescriptor getFD() {
        return this.fd;
    }

    public int getFDVal() {
        return this.fdVal;
    }

    SourceChannelImpl(SelectorProvider selectorProvider, FileDescriptor fileDescriptor) {
        super(selectorProvider);
        this.fd = fileDescriptor;
        this.fdVal = IOUtil.fdVal(fileDescriptor);
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            nd.preClose(this.fd);
            long l2 = this.thread;
            if (l2 != 0L) {
                NativeThread.signal(l2);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                return;
            }
            if (this.state == -1) {
                this.state = 1;
                return;
            }
            if (!$assertionsDisabled && (this.isOpen() || this.isRegistered())) {
                throw new AssertionError();
            }
            nd.close(this.fd);
            this.state = 1;
        }
    }

    protected void implConfigureBlocking(boolean bl2) throws IOException {
        IOUtil.configureBlocking(this.fd, bl2);
    }

    public void translateAndSetReadyOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if (n2 == 1) {
            selectionKeyImpl.readyOps(1);
        }
    }

    public void translateAndSetInterestOps(int n2, SelectionKeyImpl selectionKeyImpl) {
        if (n2 == 1) {
            n2 = 1;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            int n4;
            int n2;
            block9: {
                n2 = 0;
                this.begin();
                if (this.isOpen()) break block9;
                int n3 = 0;
                this.thread = 0L;
                this.end(n2 > 0 || n2 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return n3;
            }
            try {
                this.thread = NativeThread.current();
                while ((n2 = IOUtil.read(this.fd, byteBuffer, -1L, nd, this.lock)) == -3 && this.isOpen()) {
                }
                n4 = IOStatus.normalize(n2);
                this.thread = 0L;
                this.end(n2 > 0 || n2 == -2);
            }
            catch (Throwable throwable) {
                this.thread = 0L;
                this.end(n2 > 0 || n2 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return n4;
        }
    }

    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        return this.read(Util.subsequence(byteBufferArray, n2, n3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long read(ByteBuffer[] byteBufferArray) throws IOException {
        if (byteBufferArray == null) {
            throw new NullPointerException();
        }
        this.ensureOpen();
        Object object = this.lock;
        synchronized (object) {
            long l3;
            int n2;
            block10: {
                n2 = 0;
                this.begin();
                if (this.isOpen()) break block10;
                long l2 = 0L;
                this.thread = 0L;
                this.end(n2 > 0 || n2 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                return l2;
            }
            try {
                this.thread = NativeThread.current();
                while ((n2 = IOUtil.read(this.fd, byteBufferArray, nd)) == -3 && this.isOpen()) {
                }
                l3 = IOStatus.normalize(n2);
                this.thread = 0L;
                this.end(n2 > 0 || n2 == -2);
            }
            catch (Throwable throwable) {
                this.thread = 0L;
                this.end(n2 > 0 || n2 == -2);
                if (!$assertionsDisabled && !IOStatus.check(n2)) {
                    throw new AssertionError();
                }
                throw throwable;
            }
            if (!$assertionsDisabled && !IOStatus.check(n2)) {
                throw new AssertionError();
            }
            return l3;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$SourceChannelImpl == null ? (class$sun$nio$ch$SourceChannelImpl = SourceChannelImpl.class$("sun.nio.ch.SourceChannelImpl")) : class$sun$nio$ch$SourceChannelImpl).desiredAssertionStatus();
        Util.load();
        nd = new FileDispatcher();
    }
}

