.\"
.\" statd(8)
.\"
.\" Copyright (C) 1999 Olaf Kirch <okir@monad.swb.de>
.\" Modified by Jeffrey A. Uphoff, 1999.
.\" Modified by Lon Hohberger, 2000.
.TH rpc.statd 8 "08 Mar 2001"
.SH NAME
rpc.statd \- NSM status monitor
.SH SYNOPSIS
.B "/sbin/rpc.statd [-F] [-d] [-?] [-n " name "] [-o " port "] [-p " port "] [-V]"
.SH DESCRIPTION
The
.B rpc.statd
server implements the NSM (Network Status Monitor) RPC protocol.
This service is somewhat misnomed, since it doesn't actually provide
active monitoring as one might suspect; instead, NSM implements a
reboot notification service. It is used by the NFS file locking service,
.BR rpc.lockd ,
to implement lock recovery when the NFS server machine crashes and
reboots.
.SS Operation
For each NFS client or server machine to be monitored,
.B rpc.statd
creates a file in
.BR /var/lib/nfs/sm .
When starting, it iterates through these files and notifies the
peer
.B rpc.statd
on those machines.
.SH OPTIONS
.TP
.B -F
By default,
.B rpc.statd
forks and puts itself in the background when started. The
.B -F
argument tells it to remain in the foreground. This option is
mainly for debugging purposes.
.TP
.B -d
By default,
.B rpc.statd
sends logging messages via
.BR syslog (3)
to system log.  The
.B -d
argument forces it to log verbose output to
.B stderr
instead. This option is mainly for debugging purposes, and may only
be used in conjunction with the
.B -F
parameter.
.TP
.BI "\-n," "" " \-\-name " name 
specify a name for
.B rpc.statd
to use as the local hostname. By default,
.BR rpc.statd
will call
.BR gethostname (2)
to get the local hostname. Specifying
a local hostname may be useful for machines with more than one
interfaces.
.TP
.BI "\-o," "" " \-\-outgoing\-port "  port
specify a port for
.B rpc.statd
to send outgoing status requests from.  By default,
.BR rpc.statd
will ask
.BR portmap (8)
to assign it a port number.  As of this writing, there is not
a standard port number that
.BR portmap
always or usually assigns.  Specifying
a port may be useful when implementing a firewall.
.TP
.BI "\-p," "" " \-\-port " port
specify a port for
.B rpc.statd
to listen on.  By default,
.BR rpc.statd
will ask
.BR portmap (8)
to assign it a port number.  As of this writing, there is not
a standard port number that
.BR portmap
always or usually assigns.  Specifying
a port may be useful when implementing a firewall.
.TP
.B -?
Causes
.B rpc.statd
to print out command-line help and exit.
.TP
.B -V
Causes
.B rpc.statd
to print out version information and exit.



.SH TCP_WRAPPERS SUPPORT
This
.B rpc.statd
version is protected by the
.B tcp_wrapper
library. You have to give the clients access to
.B rpc.statd
if they should be allowed to use it. To allow connects from clients of
the .bar.com domain you could use the following line in /etc/hosts.allow:

statd: .bar.com

You have to use the daemon name 
.B statd
for the daemon name (even if the binary has a different name). For the
client names you can only use the keyword ALL or IP addresses (NOT
host or domain names).

For further information please have a look at the
.BR tcpd (8),
.BR hosts_allow (5)
and
.BR hosts_access (5)
manual pages.

.SH FILES
.BR /var/lib/nfs/state
.br
.BR /var/lib/nfs/sm/*
.br
.BR /var/lib/nfs/sm.bak/*
.SH SEE ALSO
.BR rpc.nfsd(8),
.BR portmap(8)
.SH AUTHORS
.br
Jeff Uphoff <juphoff@transmeta.com>
.br
Olaf Kirch <okir@monad.swb.de>
.br
H.J. Lu <hjl@gnu.org>
.br
Lon Hohberger <hohberger@missioncriticallinux.com>
