
#include "bugdetails.h"

#include "bugdetailsimpl.h"

BugDetails::BugDetails()
{
}

BugDetails::BugDetails( BugDetailsImpl *impl ) :
    m_impl( impl )
{
}

BugDetails::BugDetails( const BugDetails &other )
{
    (*this) = other;
}

BugDetails &BugDetails::operator=( const BugDetails &rhs )
{
    m_impl = rhs.m_impl;
    return *this;
}

BugDetails::~BugDetails()
{
}

QString BugDetails::version() const
{
    if ( !m_impl )
        return QString::null;

    return m_impl->version;
}

QString BugDetails::source() const
{
    if ( !m_impl )
        return QString::null;

    return m_impl->source;
}

QString BugDetails::compiler() const
{
    if ( !m_impl )
        return QString::null;

    return m_impl->compiler;
}

QString BugDetails::os() const
{
    if ( !m_impl )
        return QString::null;

    return m_impl->os;
}

BugDetailsPart::List BugDetails::parts() const
{
    if ( !m_impl )
        return BugDetailsPart::List();
    
    return m_impl->parts;
}

bool BugDetails::operator==( const BugDetails &rhs )
{
    return m_impl == rhs.m_impl;
}

/**
 * vim:ts=4:sw=4:et
 */
