#include "settings.h"
#include "settings.moc"

#include <qlabel.h>
#include <qlayout.h>

#include <klocale.h>

#include "ghighscores.h"

#include "board.h"
#include "ai.h"
#include "base/defines.h"


QCheckBox *createShadow(KSettingWidget *sw)
{
    QCheckBox *cb = new QCheckBox(i18n("Show tile's shadow"), sw);
    sw->settings()->plug(cb, OP_GROUP, "show piece shadow", true);
    return cb;
}

QCheckBox *createShowNext(KSettingWidget *sw)
{
    QCheckBox *cb = new QCheckBox(i18n("Show next tile"), sw);
    sw->settings()->plug(cb, OP_GROUP, "show next piece", true);
    return cb;
}

KIntNumInput *createInitLevel(KSettingWidget *sw)
{
    KIntNumInput *il = new KIntNumInput(sw);
    il->setRange(1, 20);
    sw->settings()->plug(il, OP_GROUP, "init level", 1);
    return il;
}


//-----------------------------------------------------------------------------
GameSettingsWidget::GameSettingsWidget()
    : KSettingWidget(i18n("Game"), "misc")
{
    QGridLayout *top = new QGridLayout(this, 3, 2, KDialog::marginHint(),
                                       KDialog::spacingHint());
    top->setColStretch(1, 1);

    QLabel *label = new QLabel(i18n("Initial level"), this);
    top->addWidget(label, 0, 0);
    KIntNumInput *i = createInitLevel(this);
    top->addWidget(i, 0, 1);

    QCheckBox *cb = createShadow(this);
    top->addMultiCellWidget(cb, 1, 1, 0, 1);

    cb = createShowNext(this);
    top->addMultiCellWidget(cb, 2, 2, 0, 1);
}

bool GameSettingsWidget::readShadow()
{
    KSettingWidget sw;
    QCheckBox *cb = createShadow(&sw);
    return sw.settings()->readValue(cb).toBool();
}

bool GameSettingsWidget::readShowNext()
{
    KSettingWidget sw;
    QCheckBox *cb = createShowNext(&sw);
    return sw.settings()->readValue(cb).toBool();
}

uint GameSettingsWidget::readInitLevel()
{
    KSettingWidget sw;
    KIntNumInput *il = createInitLevel(&sw);
    return sw.settings()->readValue(il).toInt();
}
