#include "inter.h"
#include "inter.moc"

#include <qtimer.h>

#include <klocale.h>
#include <kapplication.h>
#include <kmainwindow.h>
#include <kaction.h>

#include "base/version.h"
#include "base/defines.h"
#include "ai.h"
#include "field.h"
#include "settings.h"


Interface::Interface(const MPGameInfo &gi, KAccel *kacc, QWidget *parent)
: MPSimpleInterface(gi, kacc, parent)
{
	setAction(i18n("Move left"),     "Move left",     SLOT(pMoveLeft()));
	setAction(i18n("Move right"),    "Move right",    SLOT(pMoveRight()));
	setAction(i18n("Drop down"),     "Drop down",     SLOT(pDropDown()));
	setAction(i18n("One line down"), "One line down", SLOT(pOneLineDown()));
	setAction(i18n("Rotate left"),   "Rotate left",   SLOT(pRotateLeft()));
	setAction(i18n("Rotate right"),  "Rotate right",  SLOT(pRotateRight()));

	QMemArray<const char **> defaultKeys(1);
	const char *oneHumanKeys[6]
		= { "Left", "Right", "Down", "Shift", "Up", "Return" };
	defaultKeys[0] = oneHumanKeys;
	setKeysConfiguration(defaultKeys);

	defaultKeys.resize(2);
	const char *twoHumansKeys[6] = { "F", "G", "D", "Space", "E", "Alt" };
	defaultKeys[0] = twoHumansKeys;
	defaultKeys[1] = oneHumanKeys;
	setKeysConfiguration(defaultKeys);
}

Interface::~Interface()
{}

MPBoard *Interface::newBoard(uint)
{
    return static_cast<Field *>(Factory::self()->createField(this));
}

void Interface::resizeGameOverData(uint size)
{
    uint s = gameOverData.size();
    if ( s>=size ) return;
    KExtHighscores::Score score;
    for (uint i=s; i<size; i++) gameOverData.append(score);
}

void Interface::_init(bool server)
{
	if (server) {
        data.resize(nbPlayers());
        resizeGameOverData(nbPlayers());
    }
}

bool Interface::_readPlayData()
{
	bool end = FALSE;
	for (uint i=0; i<nbPlayers(); i++) {
		readingStream(i) >> data[i];
		if (data[i].end) end = TRUE;
	}
	return end;
}

void Interface::_sendPlayData()
{
	ServerPlayData sd;
	for(uint i=0; i<nbPlayers(); i++) {
		sd.prevHeight = data[prev(i)].height;
		sd.nextHeight = data[next(i)].height;
		sd.gift       = data[prev(i)].gift;
		writingStream(i) << sd;
	}
}

void Interface::_showGameOverData(bool server)
{
	if (server && nbPlayers()==1 ) {
        gameOverData[0].setType(KExtHighscores::Won);
        KExtHighscores::submitScore(gameOverData[0], this);
    } else KExtHighscores::showMultipleScores(gameOverData, this);
}

uint Interface::prev(uint i) const
{
	if ( i==0 ) return nbPlayers()-1;
	else return i-1;
}

uint Interface::next(uint i) const
{
	if ( i==(nbPlayers()-1) ) return 0;
	else return i+1;
}

// server only
void Interface::_treatInit()
{
	ServerInitData sid;
	sid.seed = kapp->random();
	sid.initLevel = GameSettingsWidget::readInitLevel();
	for (uint i=0; i<nbPlayers(); i++) {
        sid.prevName = playerName(prev(i));
        sid.nextName = playerName(next(i));
        sid.name     = playerName(i);
		writingStream(i) << sid;
	}
}

void Interface::_sendGameOverData(QDataStream &s)
{
    s << (Q_UINT32)nbPlayers();

    Q_ASSERT( gameOverData.size()==nbPlayers() );
	for (uint i=0; i<nbPlayers(); i++) {
        readingStream(i) >> gameOverData[i];
        gameOverData[i].setData("name", playerName(i));
        s << gameOverData[i];
	}
}

// client only
void Interface::_readGameOverData(QDataStream &s)
{
    Q_UINT32 nb;
    s >> nb;
    resizeGameOverData(nb);
    for (uint i=0; i<nb; i++) s >> gameOverData[i];
}
