/***************************************************************************
                            HTMLTextAreaElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLTEXTAREAELEMENT_H
#define HTMLTEXTAREAELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Multi-line text field. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html edef]-TEXTAREA">
 TEXTAREA element definition </a> in HTML 4.0.

 
 @short 
 Multi-line text field.
*/

@class HTMLFormElement;

@interface HTMLTextAreaElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Stores the initial control value (i.e., the initial value of
 <code> value </code> ).

     
*/
- (NSString *) defaultValue;

/** 
 see @ref defaultValue
     
*/
- setDefaultValue: (NSString *)arg1;

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
- (HTMLFormElement*) form;

/** 
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) accessKey;

/** 
 see @ref accessKey
     
*/
- setAccessKey: (NSString *)arg1;

/** 
 Width of control (in characters). See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-cols-TEXTAREA">
 cols attribute definition </a> in HTML 4.0.

     
*/
- (long) cols;

/** 
 see @ref cols
     
*/
- setCols: (long)arg1;

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) disabled;

/** 
 see @ref disabled
     
*/
- setDisabled: (BOOL)arg1;

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-name-TEXTAREA">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 This control is read-only. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-readonly">
 readonly attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) readOnly;

/** 
 see @ref readOnly
     
*/
- setReadOnly: (BOOL)arg1;

/** 
 Number of text rows. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-rows-TEXTAREA">
 rows attribute definition </a> in HTML 4.0.

     
*/
- (long) rows;

/** 
 see @ref rows
     
*/
- setRows: (long)arg1;

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
- (long) tabIndex;

/** 
 see @ref tabIndex
     
*/
- setTabIndex: (long)arg1;

/** 
 The type of this form control.

     
*/
- (NSString *) type;

/** 
 The current textual content of the multi-line text field. If
 the entirety of the data can not fit into a single wstring, the
 implementation may truncate the data.

     
*/
- (NSString *) value;

/** 
 see @ref value
     
*/
- setValue: (NSString *)arg1;

/** 
 Removes keyboard focus from this element.
     
*/
- blur;

/** 
 Gives keyboard focus to this element.
     
*/
- focus;

/** 
 Select the contents of the <code> TEXTAREA </code> .
     
*/
- select;
@end

#endif
