/***************************************************************************
                            HTMLAnchorElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLANCHORELEMENT_H
#define HTMLANCHORELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 The anchor element. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html edef]-A"> A
 element definition </a> in HTML 4.0.

 
 @short 
 The anchor element.
*/

@interface HTMLAnchorElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) accessKey;

/** 
 see @ref accessKey
     
*/
- setAccessKey: (NSString *)arg1;

/** 
 The character encoding of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-charset">
 charset attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) charset;

/** 
 see @ref charset
     
*/
- setCharset: (NSString *)arg1;

/** 
 Comma-separated list of lengths, defining an active region
 geometry. See also <code> shape </code> for the shape of the
 region. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-coords">
 coords attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) coords;

/** 
 see @ref coords
     
*/
- setCoords: (NSString *)arg1;

/** 
 The URI of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-href">
 href attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) href;

/** 
 see @ref href
     
*/
- setHref: (NSString *)arg1;

/** 
 Language code of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-hreflang">
 hreflang attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) hreflang;

/** 
 see @ref hreflang
     
*/
- setHreflang: (NSString *)arg1;

/** 
 Anchor name. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-name-A">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 Forward link type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-rel">
 rel attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) rel;

/** 
 see @ref rel
     
*/
- setRel: (NSString *)arg1;

/** 
 Reverse link type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-rev">
 rev attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) rev;

/** 
 see @ref rev
     
*/
- setRev: (NSString *)arg1;

/** 
 The shape of the active area. The coordinates are given by
 <code> coords </code> . See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-shape">
 shape attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) shape;

/** 
 see @ref shape
     
*/
- setShape: (NSString *)arg1;

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
- (long) tabIndex;

/** 
 see @ref tabIndex
     
*/
- setTabIndex: (long)arg1;

/** 
 Frame to render the resource in. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.-[html adef]-target">
 target attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) target;

/** 
 see @ref target
     
*/
- setTarget: (NSString *)arg1;

/** 
 Advisory content type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-type-A">
 type attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) type;

/** 
 see @ref type
     
*/
- setType: (NSString *)arg1;

/** 
 Removes keyboard focus from this element.

     
*/
- blur;

/** 
 Gives keyboard focus to this element.

     
*/
- focus;
@end

#endif
