/***************************************************************************
                            CDATASection.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef CDATASECTION_H
#define CDATASECTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/Text.h>

/**

 CDATA sections are used to escape blocks of text containing
 characters that would otherwise be regarded as markup. The only
 delimiter that is recognized in a CDATA section is the "]]&gt;"
 string that ends the CDATA section. CDATA sections can not be
 nested. The primary purpose is for including material such as XML
 fragments, without needing to escape all the delimiters.

  The <code> DOMString </code> attribute of the <code> Text </code>
 node holds the text that is contained by the CDATA section. Note
 that this may contain characters that need to be escaped outside of
 CDATA sections and that, depending on the character encoding
 ("charset") chosen for serialization, it may be impossible to write
 out some characters as part of a CDATA section.

  The <code> CDATASection </code> interface inherits the <code>
 CharacterData </code> interface through the <code> Text </code>
 interface. Adjacent <code> CDATASections </code> nodes are not
 merged by use of the Element.-normalize method.

 
 @short 
 CDATA sections are used to escape blocks of text containing
 characters that would otherwise be regarded as markup.
*/
@interface CDATASection : Text 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;
@end

#endif
