package org.kde.koala;
import org.kde.qt.*;


/** {@link Slave} emits these signals */
public interface SlaveSignals {
	void connected();
	void destroyed( QObject obj );
//	void statEntry( UDSEntry arg1 );
	void connectFinished();

/** 
 Emitted when an io-slave requests cached password to be
 deleted for the specified group.

*/
	void delAuthorization( String grpkey );
	void needSubURLData();
	void needProgressId();
	void infoMessage( String arg1 );
	void canResume( int arg1 );
	void error( int arg1, String arg2 );
	void data( byte[] arg1 );
	void dataReq();
	void processedSize( int arg1 );
	void finished();
//	void listEntries( UDSEntryList arg1 );
	void redirection( KURL arg1 );
	void slaveDied( Slave slave );

/** 
 Emitted whenever login (username/password) information
 needs to be cached.

 NOTE: this signal is also emitted whenever a

*/
	void authorizationKey( String arg1, String arg2, boolean arg3 );
	void warning( String arg1 );
	void totalSize( int arg1 );
	void errorPage();
	void speed(  long arg1 );
//	void metaData( MetaData arg1 );
	void slaveStatus( long arg1, String arg2, String arg3, boolean arg4 );
	void mimeType( String arg1 );
}

