/***************************************************************************
                            KSystemTray.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

  KDE System Tray Window class

 This class implements system tray windows.

 A tray window is a small window (typically 24x24 pixel) that docks
 into the system tray in the desktop panel. It usually displays an
 icon or an animated icon there. The icon serves as representative
 for the application, similar to a taskbar button, but consumes less
 screen space.

 When the user clicks with the left mouse button on the icon, the
 main application window is shown/raised and activated. With the
 right mouse button, she gets a popupmenu with application specific
 commands, including "Minimize/Restore" and "Quit".

 Docking happens magically when calling show(). The window undocks
 with either hide() or when it is destroyed.

 KSystemTray inherits methods such as {@link #setPixmap} and {@link #setMovie} to
 specify an icon or movie (animated icon) respectively. It is
 designed to be usable "as is", without the need to subclass it. In
 case you need to provide something special (such as an additional
 popupmenu on a click with the left mouse button), you can subclass
 anyway, of course.

 Having an icon on the system tray is a useful technique for
 daemon-like applications that may run for some time without user
 interaction but have to be there immediately when the user needs
 them. Examples are kppp, kisdn, kscd, kmix or knotes. With kppp and
 kisdn, the docked icon even provides real-time information about
 the network status.

 See {@link KSystemTraySignals} for signals emitted by KSystemTray.

 See {@link KSystemTrayEventHandling} for event handlers to override in subclasses of KSystemTray.

 @author Matthias Ettrich <ettrich@kde.org>

 @short KDE System Tray Window class.
*/
public class KSystemTray extends QLabel  {
	protected KSystemTray(Class dummy){super((Class) null);}

	private native void newKSystemTray( QWidget parent, String name);

/** 
 Construct a KSystemTray widget just like any other widget.

 The parent widget <code>parent</code> has a special meaning:
 Besides owning the tray window, the parent widget will
 dissappear from taskbars when it is iconified while the tray
 window is visible. This is the desired behaviour. After all,
 the tray window <code>is</code> the parent's taskbar icon.

 Furthermore, the parent widget is shown or raised respectively
 when the user clicks on the trray window with the left mouse
 button.

*/
	public KSystemTray( QWidget parent, String name) {
		super((Class) null);
		newKSystemTray( parent, name);
	}
	private native void newKSystemTray();
	public KSystemTray() {
		super((Class) null);
		newKSystemTray();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
       Reimplemented to provide the standard show/raise behaviour
       for the parentWidget() and the context menu.

       Feel free to reimplement this if you need something special.
     
*/
	protected native void mousePressEvent( QMouseEvent arg1);

/** 
       Reimplemented to provide the standard show/raise behaviour
       for the parentWidget() and the context menu.

       Feel free to reimplement this if you need something special.
     
*/
	protected native void mouseReleaseEvent( QMouseEvent arg1);

/** 
       Access to the context menu. This makes it easy to add new items
       to it.
     
*/
	protected native KPopupMenu contextMenu();

/** 
       Makes it easy to adjust some menu items right before the
       context menu becomes visible.
     
*/
	protected native void contextMenuAboutToShow( KPopupMenu menu);

/** 
       Reimplemented for internal reasons.
     
*/
	protected native void showEvent( QShowEvent arg1);

/** 
       Reimplemented for internal reasons.
     
*/
	protected native void enterEvent( QEvent arg1);
}
