/***************************************************************************
                            KPreviewWidgetBase.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Abstract baseclass for all preview widgets which shall be used via
 KFileDialog.setPreviewWidget(const KPreviewWidgetBase ).
 Ownership will be transferred to KFileDialog, so you have to create
 the preview with "new" and let KFileDialog delete it.

 Just derive your custom preview widget from KPreviewWidgetBase and implement
 all the pure virtual methods. The slot showPreview(const KURL &) is called
 every time the file selection changes.

 @author Frerich Raabe <raabe@kde.org>
 
 @short Abstract baseclass for all preview widgets.

*/
public class KPreviewWidgetBase extends QWidget  {
	protected KPreviewWidgetBase(Class dummy){super((Class) null);}


/** 
 This slot is called everytime the user selects another file in the
 file dialog. Implement the stuff necessary to reflect the change here.

*/
	public native void showPreview( KURL url);

/** 
 Reimplement this to clear the preview. This is called when e.g. the
 selection is cleared or when multiple selections exist, or the directory
 is changed.
     
*/
	public native void clearPreview();
}
