/***************************************************************************
                            KPanelApplet.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Implement a panel applet.

 Panel applets

 Note: For security and stability reasons the panel won't load
 untrusted third party applets directly into its namespace but via an
 external wrapper process.

 The panel locates available applets by searching for applet desktop
 files in (ALL_KDEDIRS)/share/apps/kicker/applets. Every panel applet should
 install a desktop file there to be recognised by the panel.

 Besides standard keys like "Name", "Comment" and "Icon" there are
 two panel applet specific keys:

 Used by the panel to locate the applet DSO (Dynamic Shared Object)
 Example: X-KDE-Library=libexampleapplet

 Similar to {@link KApplication} and {@link KUniqueApplication} there are
 two types of panel applets. Use unique applets when it makes no
 sence to run more than one instance of a applet in the panel. A
 good example for unique applets is the taskbar applet.  Use normal
 applets when you need instance specific configuration. An example
 is the koolclock applet where you might want to run two instances
 in your panel, one configured as analog clock, the other one as
 digital clock. X-KDE-UniqueApplet is a boolean key which defaults
 to "false".  Example: X-KDE-UniqueApplet=true

 Back to panel applet DSOs, the following conventions are used for KDE:
 Name:    lib<appletname>applet.la
 LDFLAGS: -module -no-undefined

 To implement a panel applet it is not enough to write a class
 inheriting from KPanelApplet but you also have to provide a
 factory function in your DSO.  A sample factory function could look
 like this:

 <pre>

 extern "C"
 {
     KPanelApplet init(QWidget parent, String configFile)
     {
         KGlobal.locale().insertCatalogue("exampleapplet");
         return new ExampleApplet(configFile, KPanelApplet.Normal,
                       KPanelApplet.About | KPanelApplet.Help | KPanelApplet.Preferences,
                       parent, "exampleapplet");
     }
 }

 </pre>

 Note: Don't change the factory function signature or the panel will
 fail to load your applet.

 See {@link KPanelAppletSignals} for signals emitted by KPanelApplet.

 See {@link KPanelAppletEventHandling} for event handlers to override in subclasses of KPanelApplet.

 @author Matthias Elter <elter@kde.org>

 @short KDE Panel Applet class.
*/
public class KPanelApplet extends QFrame  {
	protected KPanelApplet(Class dummy){super((Class) null);}

	private native void newKPanelApplet( String configFile, int t, int actions, QWidget parent, String name, int f);

/** 
 Constructs a KPanelApplet just like any other widget.

*/
	public KPanelApplet( String configFile, int t, int actions, QWidget parent, String name, int f) {
		super((Class) null);
		newKPanelApplet( configFile, t, actions, parent, name, f);
	}
	private native void newKPanelApplet( String configFile);
	public KPanelApplet( String configFile) {
		super((Class) null);
		newKPanelApplet( configFile);
	}

/** 
 Destructor.

*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns a suggested width for a given height.

 Every applet should reimplement this function.

 Depending on the panel orientation the height (horizontal panel) or the
 width (vertical panel) of the applets is fixed.
 The exact values of the fixed size component depend on the panel size.

 On a horizontal panel the applet height is fixed, the panel will
 call {@link #widthForHeight} with <code>height</code>
 equal to 'the fixed applet height'
 when laying out the applets.

 The applet can now choose the other size component (width)
 based on the given height.

 The width you return is granted.

*/
	public native int widthForHeight( int height);

/** 

 Every applet should reimplement this function.

 Depending on the panel orientation the height (horizontal panel) or the
 width (vertical panel) of the applets is fixed.
 The exact values of the fixed size component depend on the panel size.

 On a vertical panel the applet width is fixed, the panel will
 call {@link #heightForWidth} with <code>width</code>
 equal to 'the fixed applet width'
 when layint out the applets.

 The applet can now choose the other size component (height)
 based on the given width.

 The height you return is granted.

*/
	public native int heightForWidth( int width);

/** 
 Always use this {@link KConfig} object to save/load your applets configuration.

 For unique applets this config object will write to a config file called
 <appletname>rc in the users local KDE directory.

 For normal applets this config object will write to a instance specific config file
 called <appletname><instanceid>rc in the users local KDE directory.

*/
	public native KConfig config();

/** 

*/
	public native int type();

/** 

*/
	public native int actions();

/** 
 Generic action dispatcher. Called  when the user selects an item
 from the applets RMB menu.

 Reimplement this function to handle actions.

 For About, Help, Preferences and ReportBug, use the convenience handlers
 ref about(), help(), preferences(), reportBug()

*/
	public native void action( int a);

/** 
 Don't reimplement, this is used internally

*/
	public native void slotSetOrientation( int o);

/** 
 Don't reimplement, this is used internally

*/
	public native void slotSetPopupDirection( int d);

/** 
 Is called when the user selects "About" from the applet's RMB menu.
 Reimplement this function to launch a about dialog.

 Note that this is called only when your applet supports the About action.
 See {@link Action} and KPanelApplet().

*/
	protected native void about();

/** 
 Is called when the user selects "Help" from the applet's RMB menu.
 Reimplement this function to launch a manual or help page.

 Note that this is called only when your applet supports the Help action.
 See {@link Action} and KPanelApplet().

*/
	protected native void help();

/** 
 Is called when the user selects "Preferences" from the applet's RMB menu.
 Reimplement this function to launch a preferences dialog or kcontrol module.

 Note that this is called only when your applet supports the preferences action.
 See {@link Action} and KPanelApplet().

*/
	protected native void preferences();

/** 
 Is called when the user selects "Report bug" from the applet's RMB menu.
 Reimplement this function to launch a bug reporting dialog.

 Note that this is called only when your applet supports the ReportBug
 action.
 See {@link Action} and KPanelApplet()

*/
	protected native void reportBug();

/** 

*/
	protected native int orientation();

/** 
 The orientation changed to <code>orientation.</code> Reimplement this
 change handler in order to adjust the look of your applet.

*/
	protected native void orientationChange( int arg1);

/** 
 You may need this if you want to popup menus at the right position.

 See {@link #popupDirectionChange}

*/
	protected native int popupDirection();

/** 
 The popup direction changed to <code>direction.</code> Reimplement this
 change handler in order to adjust the look of your applet.

*/
	protected native void popupDirectionChange( int arg1);
	public static final int Normal = 0;
	public static final int Stretch = 0;
	public static final int About = 1;
	public static final int Help = 2;
	public static final int Preferences = 4;
	public static final int ReportBug = 8;
	public static final int Up = 0;
	public static final int Down = 0;
	public static final int Left = 1;
	public static final int Right = 2;
}
