/***************************************************************************
                            KIconLoader.java -  description
                             -------------------
    begin                : Wed Feb 13 15:00:20 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb 13 15:00:20 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Iconloader for KDE.

 KIconLoader will load the current icon theme and all its base themes.
 Icons will be searched in any of these themes. Additionally, it caches
 icons and applies effects according the the user's preferences.

 In KDE, it is encouraged to load icons by "Group". An icon group is a
 location on the screen where icons are being used. Standard groups are:
 Desktop, Toolbar, MainToolbar, Small and Panel. Each group has some
 centrally configured properties bound to it, including the icon size
 and effects. This makes it possible to offer a consistent icon look in
 all KDE applications.

 The standard groups are defined below.

 The icons are stored on disk in an icon theme or in a standalone
 directory. The icon theme directories contain multiple sizes and/or
 depths for the same icon. The iconloader will load the correct one based
 on the icon group and the current theme. Icon themes are stored globally
 in share/icons, or, application specific in share/apps/$appdir/icons.

 The standalone directories contain just one version of an icon. The
 directories that are searched are: $appdir/pics and $appdir/toolbar.
 Icons in these directories can be loaded by using the special group
 "User".

 
 @short 
 Iconloader for KDE.
*/
public class  KIconLoader implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KIconLoader(Class dummy){}

	private native void newKIconLoader( String appname, KStandardDirs dirs);

/** 
 Constructs an iconloader.

*/
	public KIconLoader( String appname, KStandardDirs dirs) {
		newKIconLoader( appname, dirs);
	}
	private native void newKIconLoader();
	public KIconLoader() {
		newKIconLoader();
	}

/**  Cleanup 
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Adds <code>appname</code> to the list of application specific directories.

*/
	public native void addAppDir( String appname);

/** 
 Loads an icon. It will try very hard to find an icon which is
 suitable. If no exact match is found, a close match is searched.
 If neither an exact nor a close match is found, a null pixmap or
 the "unknown" pixmap is returned, depending on the value of the
 <code>canReturnNull</code> parameter.

*/
	public native QPixmap loadIcon( String name, int group, int size, int state, String path_store, boolean canReturnNull);
	public native QPixmap loadIcon( String name, int group);

/** 
 Creates an icon set, that will do on-demand loading of the icon.
 Loading itself is done by calling {@link loadIcon} .

*/
	public native QIconSet loadIconSet( String name, int group, int size);
	public native QIconSet loadIconSet( String name, int group);

/** 
 Returns the path of an icon.

*/
	public native String iconPath( String name, int group_or_size, boolean canReturnNull);
	public native String iconPath( String name, int group_or_size);

/** 
 Loads an animated icon.

*/
	public native QMovie loadMovie( String name, int group, int size);
	public native QMovie loadMovie( String name, int group);

/** 
 Returns the path to an animated icon.

*/
	public native String moviePath( String name, int group, int size);
	public native String moviePath( String name, int group);

/** 
 Loads an animated icon. In the future, this will be replaced by a
 routine which loads an MNG animation and returns a QMovie.

*/
	public native ArrayList loadAnimated( String name, int group, int size);

/** 
 Queries all available icons for a specific group, having a specific
 context.

*/
	public native ArrayList queryIcons( int group_or_size, int context);

/** 
 Queries all available icons for a specific context.

*/
	public native ArrayList queryIconsByContext( int group_or_size, int context);

/** 

*/
	public native int currentSize( int group);

/** 
 Returns a pointer to the current theme. Can be used to query
 available and default sizes for groups.
     
*/
	public native KIconTheme theme();

/** 
 Returns a pointer to the KIconEffect object used by the icon loader.
     
*/
	public native KIconEffect iconEffect();

/** 
 Called by KInstance.newIconLoader to reconfigure the icon loader
     
*/
	public native void reconfigure( String _appname, KStandardDirs _dirs);

/** 
 Returns if the user wants to use blend the icons with the background
  using the alpha channel information for a given group.
     
*/
	public native boolean alphaBlending( int group);

/** 
 Returns the unknown icon. An icon that is used when no other icon
 can be found.
     
*/
	public static native QPixmap unknown();

/**  Load a desktop icon.  
*/
	public static native QPixmap DesktopIcon( String name, int size, int state, KInstanceInterface instance);
	public static native QPixmap DesktopIcon( String name);

/**  Load a desktop icon. 
*/
	public static native QPixmap DesktopIcon( String name, KInstanceInterface instance);

/**  Load a desktop icon, and apply the necessary effects to get an IconSet.  
*/
	public static native QIconSet DesktopIconSet( String name, int size, KInstanceInterface instance);
	public static native QIconSet DesktopIconSet( String name);

/**  Load a toolbar icon.  
*/
	public static native QPixmap BarIcon( String name, int size, int state, KInstanceInterface instance);
	public static native QPixmap BarIcon( String name);

/**  Load a toolbar icon.  
*/
	public static native QPixmap BarIcon( String name, KInstanceInterface instance);

/**  Load a toolbar icon, and apply the neccesary effects to get an IconSet.  
*/
	public static native QIconSet BarIconSet( String name, int size, KInstanceInterface instance);
	public static native QIconSet BarIconSet( String name);

/**  Load a small icon.  
*/
	public static native QPixmap SmallIcon( String name, int size, int state, KInstanceInterface instance);
	public static native QPixmap SmallIcon( String name);

/**  Load a small icon.  
*/
	public static native QPixmap SmallIcon( String name, KInstanceInterface instance);

/**  Load a small icon, and apply the neccesary effects to get an IconSet.  
*/
	public static native QIconSet SmallIconSet( String name, int size, KInstanceInterface instance);
	public static native QIconSet SmallIconSet( String name);

/**  Load a main toolbar icon.  
*/
	public static native QPixmap MainBarIcon( String name, int size, int state, KInstanceInterface instance);
	public static native QPixmap MainBarIcon( String name);

/**  Load a main toolbar icon.  
*/
	public static native QPixmap MainBarIcon( String name, KInstanceInterface instance);

/**  Load a main toolbar icon, and apply the effects to get an IconSet.  
*/
	public static native QIconSet MainBarIconSet( String name, int size, KInstanceInterface instance);
	public static native QIconSet MainBarIconSet( String name);

/**  Load a user icon. 
*/
	public static native QPixmap UserIcon( String name, int state, KInstanceInterface instance);
	public static native QPixmap UserIcon( String name);

/**  Load a user icon. 
*/
	public static native QPixmap UserIcon( String name, KInstanceInterface instance);

/**  Load a user icon, and apply the effects to get an IconSet.  
*/
	public static native QIconSet UserIconSet( String name, KInstanceInterface instance);
	public static native QIconSet UserIconSet( String name);

/**  Returns the current icon size for a specific group.  
*/
	public static native int IconSize( int group, KInstanceInterface instance);
	public static native int IconSize( int group);
}
