package org.kde.koala;
import org.kde.qt.*;


/** {@link KAboutApplication} emits these signals */
public interface KAboutApplicationSignals {

/** 
 The User3 button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotUser3} is not replaced.
     
*/
	void user3Clicked();
	void destroyed( QObject obj );

/** 
 The Yes button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotYes} is not replaced.
     
*/
	void yesClicked();

/** 
 Send an email to this person.

 The application must provide the
  functionality.
   
*/
	void sendEmail( String name, String email );

/** 
 The Help button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotHelp} is not replaced.
     
*/
	void helpClicked();

/** 
 The Apply button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotApply} is not replaced.
     
*/
	void applyClicked();

/** 
 The Default button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotDefault} is not replaced.
     
*/
	void defaultClicked();

/** 
 The Try button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotTry} is not replaced.
     
*/
	void tryClicked();

/** 
 The No button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotNo} is not replaced.
     
*/
	void noClicked();

/** 
 The detailsWidget is about to get shown. This is your last chance
 to call setDetailsWidget if you haven't done so yet.
     
*/
	void aboutToShowDetails();

/** 
 The Cancel button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotCancel} is not replaced.
     
*/
	void cancelClicked();

/** 
 Do not use this signal. Is is kept for compatibility reasons.
 Use {@link KAboutApplication#applyClicked} instead.
     
*/
	void apply();

/** 
 The background tile has changed.
     
*/
	void backgroundChanged();

/** 
 The dialog has finished.

 A dialog emits finished after a user clicks a button that ends
 the dialog.

 This signal is also emitted when you call {@link KAboutApplication#hide}

 If you have stored a pointer to the
 dialog do <em>not</em> try to delete the pointer in the slot that is
 connected to this signal.

 You should use {@link KAboutApplication#delayedDestruct} instead.
     
*/
	void finished();

/** 
 The User1 button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotUser1} is not replaced.
     
*/
	void user1Clicked();

/** 
 Emitted when the margin size and/or spacing size 
 have changed.

 Use {@link KAboutApplication#marginHint} and  {@link KAboutApplication#spacingHint} in your slot
 to get the new values.
     
*/
	void layoutHintChanged();

/** 
 The Close button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotClose} is not replaced.
     
*/
	void closeClicked();

/** 
 The OK button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotOk} is not replaced.
     
*/
	void okClicked();

/** 
 The dialog is about to be hidden.

 A dialog is hidden after a user clicks a button that ends
 the dialog or when the user switches to another desktop or
 minimizes the dialog.
     
*/
	void hidden();

/** 
 Open the selected URL.
   
*/
	void openURL( String url );

/** 
 The User2 button was pressed. This signal is only emitted if
 {@link KAboutApplication#slotUser2} is not replaced.
     
*/
	void user2Clicked();

/** 
 A page is about to be shown.
     
*/
	void aboutToShowPage( QWidget page );
}

