/***************************************************************************
                            Job.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The base class for all jobs.
 For all jobs created in an application, the code looks like

 <pre>
   KIO.Job  job = KIO.someoperation( some parameters );
   connect( job, SIGNAL(" result( KIO.Job  )"),
            this, SLOT(" slotResult( KIO.Job  )") );
 </pre>
   (other connects, specific to the job)

 And slotResult is usually at least:

 <pre>
  if ( job.error() )
      job.showErrorDialog( this or null  );
 </pre>

     
 See {@link JobSignals} for signals emitted by Job.

 See {@link JobEventHandling} for event handlers to override in subclasses of Job.

 @short 
 The base class for all jobs.
*/
public class Job extends QObject  {
	protected Job(Class dummy){super((Class) null);}

	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Abort this job.
 This kills all subjobs and deletes the job.

*/
	public native void kill( boolean quietly);
	public native void kill();

/** 

*/
	public native int error();

/** 

*/
	public native int progressId();

/** 

*/
	public native String errorText();

/** 
 Converts an error code and a non-i18n error message into an
 error message in the current language. The low level (non-i18n)
 error message (usually a url) is put into the translated error
 message using %1.
 Example for errid == ERR_CANNOT_OPEN_FOR_READING:
   i18n( "Could not read\n%1" ).arg( errortext );
 Use this to display the error yourself, but for a dialog box
 use {@link Job#showErrorDialog}.
         
*/
	public native String errorString();

/** 
 Converts an error code and a non-i18n error message into an
 html error message in the current language. The low level (non-i18n)
 error message (usually a url) is put into the translated error
 message using %1.
         
*/
	public native String htmlErrorString();

/** 
 Display a dialog box to inform the user of the error given by
 this job.
 Only call if {@link error} is not 0, and only in the slot connected
 to {@link result}.

*/
	public native void showErrorDialog( QWidget parent);
	public native void showErrorDialog();

/** 
 Enable or disable the automatic error handling. When automatic
 error handling is enabled and an error occurs, then showErrorDialog
 is called with the specified parentWidget (if supplied) , right before
 the emission of the result signal.

 The default is false.

 See also {@link isAutoErrorHandlingEnabled} , {@link showErrorDialog}

*/
	public native void setAutoErrorHandlingEnabled( boolean enable, QWidget parentWidget);
	public native void setAutoErrorHandlingEnabled( boolean enable);

/** 
 Returns whether automatic error handling is enabled or disabled.
 See also {@link setAutoErrorHandlingEnabled} .
         
*/
	public native boolean isAutoErrorHandlingEnabled();

/** 
 Associate this job with a window given by <code>window.</code>
         
*/
	public native void setWindow( QWidget window);

/** 
 Returns the window this job is associated with.
         
*/
	public native QWidget window();

/** 
 Set meta data to be sent to the slave.
         
*/
//	public native void setMetaData( MetaData arg1);

/** 
 Add key/value pair to the meta data that is sent to the slave.
         
*/
	public native void addMetaData( String key, String value);

/** 
 Add key/value pairs to the meta data that is sent to the slave.
 If a certain key already existed, it will be overridden.
         
*/
//	public native void addMetaData( String arg1, String values);

/** 
 Add key/value pairs to the meta data that is sent to the slave.
 If a certain key already existed, it will remain unchanged.
         
*/
	public native void mergeMetaData( String arg1, String values);

/** 

         
*/
//	public native MetaData outgoingMetaData();

/** 
 Get meta data received from the slave.
 (Valid when first data is received and/or slave is finished)
         
*/
//	public native MetaData metaData();

/** 
 Query meta data received from the slave.
 (Valid when first data is received and/or slave is finished)
         
*/
	public native String queryMetaData( String key);
	private native void newJob( boolean showProgressInfo);
	public Job( boolean showProgressInfo) {
		super((Class) null);
		newJob( showProgressInfo);
	}

/** 
 Add a job that has to be finished before a result
 is emitted. This has obviously to be called before
 the finish signal is emitted by the slave.

 If <code>inheritMetaData</code> is true, the subjob will 
 inherit the meta data from this job.
         
*/
	protected native void addSubjob( int job, boolean inheritMetaData);
	protected native void addSubjob( int job);

/** 
 Mark a sub job as being done. If it's the last to
 wait on the job will emit a result - jobs with
 two steps might want to override slotResult
 in order to avoid calling this method.
         
*/
	protected native void removeSubjob( int job);

/** 
 Utility function for inherited jobs.
 Emits the percent signal if bigger than m_percent,
 after calculating it from the parameters.
         
*/
	protected native void emitPercent( int processedSize, int totalSize);

/** 
 Utility function for inherited jobs.
 Emits the speed signal and starts the timer for removing that info
         
*/
	protected native void emitSpeed( long bytes_per_second);

/** 
 Utility function to emit the result signal, and suicide this job.
 It first tells the observer to hide the progress dialog for this job.
         
*/
	protected native void emitResult();

/** 
 Called whenever a subjob finishes.
 Default implementation checks for errors and propagates
 to parent job, then calls {@link removeSubjob}.
 Override if you don't want subjobs errors to be propagated.
         
*/
	protected native void slotResult( Job job);

/** 
 Forward signal from subjob.
         
*/
	protected native void slotSpeed( Job arg1, long bytes_per_second);

/** 
 Forward signal from subjob.
         
*/
	protected native void slotInfoMessage( Job arg1, String arg2);

/** 
 Remove speed information.
         
*/
	protected native void slotSpeedTimeout();
}
