/***************************************************************************
                            HTMLOptionElement.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A selectable choice. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-OPTION">
 OPTION element definition </a> in HTML 4.0.

 
 @short 
 A selectable choice.
*/
public class HTMLOptionElement extends HTMLElement  {
	protected HTMLOptionElement(Class dummy){super((Class) null);}

	private native void newHTMLOptionElement();
	public HTMLOptionElement() {
		super((Class) null);
		newHTMLOptionElement();
	}
	private native void newHTMLOptionElement( HTMLOptionElement other);
	public HTMLOptionElement( HTMLOptionElement other) {
		super((Class) null);
		newHTMLOptionElement( other);
	}
	private native void newHTMLOptionElement( DOMNode other);
	public HTMLOptionElement( DOMNode other) {
		super((Class) null);
		newHTMLOptionElement( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
	public native HTMLFormElement form();

/** 
 Stores the initial value of the <code> selected </code>
 attribute.

     
*/
	public native boolean defaultSelected();

/** 
 see {@link defaultSelected}
     
*/
	public native void setDefaultSelected( boolean arg1);

/** 
 The text contained within the option element.

     
*/
	public native String text();

/** 
 The index of this <code> OPTION </code> in its parent <code>
 SELECT </code> .

     
*/
	public native long index();

/** 
 see {@link index}

 This function is obsolete - the index property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
	public native void setIndex( long arg1);

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
	public native boolean disabled();

/** 
 see {@link disabled}
     
*/
	public native void setDisabled( boolean arg1);

/** 
 Option label for use in hierarchical menus. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-label-OPTION">
 label attribute definition </a> in HTML 4.0.

     
*/
	public native String label();

/** 
 see {@link label}
     
*/
	public native void setLabel( String arg1);

/** 
 Means that this option is initially selected. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-selected">
 selected attribute definition </a> in HTML 4.0.

     
*/
	public native boolean selected();

/** 
 see {@link selected}
     
*/
	public native void setSelected( boolean arg1);

/** 
 The current form control value. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-value-OPTION">
 value attribute definition </a> in HTML 4.0.

     
*/
	public native String value();

/** 
 see {@link value}
     
*/
	public native void setValue( String arg1);
}
