/***************************************************************************
                            kde_KWinModule.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KWINMODULE
#define KDE_KWINMODULE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**


 The class KWinModule provides information about the state of the
 window manager as required by windowmanager modules. It informs a
 module about all currently managed windows and changes to them (via
 Qt signals).

 KWinModule uses NETRootInfo internally. Modules written with this
 class will work fine under any window manager that implements the
 NET_WM protocol.

 There are no methods to manipulate windows. Those are defined in
 the classes KWin, NETWinInfo and NETRootInfo.

 @author Matthias Ettrich (ettrich@kde.org)

 @version $Id: kde_KWinModule.h,v 1.3 2002/02/21 00:43:14 rdale Exp $
 
 @short Base class for KDE Window Manager modules.

*/

/** 
 Creates a KWinModule object and connects to the window
 manager.

*/
kde_KWinModule * kde_new_KWinModule(qt_QObject * parent);

/** 
 Destructor. Internal cleanup, nothing fancy.

*/
void kde_del_KWinModule( kde_KWinModule* p );

/** 
 Test to see if @p WId still managed at present.

*/
int kde_KWinModule_hasWId(kde_KWinModule* instPointer,unsigned int arg1);

/** 
 Returns the current virtual desktop.

*/
int kde_KWinModule_currentDesktop(kde_KWinModule* instPointer);

/** 
 Returns the number of virtual desktops.

*/
int kde_KWinModule_numberOfDesktops(kde_KWinModule* instPointer);

/** 
 Returns the currently active window, or 0 if no window is active.

*/
unsigned int kde_KWinModule_activeWindow(kde_KWinModule* instPointer);

/** 
 Returns the workarea for the specified desktop, or the current
 work area if no desktop has been specified.

*/
qt_QRect* kde_KWinModule_workArea(kde_KWinModule* instPointer,int arg1);

/** 
 Returns the name of the specified desktop.

*/
qt_QString * kde_KWinModule_desktopName(kde_KWinModule* instPointer,int desktop);

/** 
 Sets the name of the specified desktop.

*/
void kde_KWinModule_setDesktopName(kde_KWinModule* instPointer,int desktop, qt_QString * name);

/** 
 Informs kwin via dcop to not manage a window with the
 specified @p title.

 Useful for swallowing legacy applications, for example java
 applets.

     
*/
void kde_KWinModule_doNotManage(kde_KWinModule* instPointer,qt_QString * title);

#endif
