/***************************************************************************
                            kde_KDoubleNumInput.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDOUBLENUMINPUT
#define KDE_KDOUBLENUMINPUT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 KDoubleNumInput combines a @ref QSpinBox and optionally a @ref QSlider
 with a label to make an easy to use control for setting some float
 parameter. This is especially nice for configuration dialogs,
 which can have many such combinated controls.

 The slider is created only when the user specifies a range
 for the control using the setRange function with the slider
 parameter set to "true".

 A special feature of KDoubleNumInput, designed specifically for
 the situation when there are several KDoubleNumInputs in a column,
 is that you can specify what portion of the control is taken by the
 QSpinBox (the remaining portion is used by the slider). This makes
 it very simple to have all the sliders in a column be the same size.

 It uses @ref KFloatValidator validator class. KDoubleNumInput enforces the
 value to be in the given range.

 @short An input control for real numbers, consisting of a spinbox and a slider.
 
*/

/** 
 Constructs an input control for double values
 with initial value 0.0.
     
*/
kde_KDoubleNumInput * kde_new_KDoubleNumInput(qt_QWidget * parent, char* name);

/** 
 Constructor

*/
kde_KDoubleNumInput * kde_new_KDoubleNumInput1(double value, qt_QWidget * parent, char* name);

/** 
 destructor
     
*/
void kde_del_KDoubleNumInput( kde_KDoubleNumInput* p );

/** 
 Constructor

 put it below other KNumInput

*/
kde_KDoubleNumInput * kde_new_KDoubleNumInput2(kde_KNumInput* below, double value, qt_QWidget * parent, char* name);

/** 

*/
double kde_KDoubleNumInput_value(kde_KDoubleNumInput* instPointer);

/** 

*/
qt_QString * kde_KDoubleNumInput_suffix(kde_KDoubleNumInput* instPointer);

/** 

*/
qt_QString * kde_KDoubleNumInput_prefix(kde_KDoubleNumInput* instPointer);

/** 

*/
int kde_KDoubleNumInput_precision(kde_KDoubleNumInput* instPointer);

/** 

*/
qt_QString * kde_KDoubleNumInput_specialValueText(kde_KDoubleNumInput* instPointer);

/** 

*/
void kde_KDoubleNumInput_setRange(kde_KDoubleNumInput* instPointer,double min, double max, double step, int slider);

/** 
 Sets the minimum value.
     
*/
void kde_KDoubleNumInput_setMinValue(kde_KDoubleNumInput* instPointer,double min);

/** 

*/
double kde_KDoubleNumInput_minValue(kde_KDoubleNumInput* instPointer);

/** 
 Sets the maximum value.
     
*/
void kde_KDoubleNumInput_setMaxValue(kde_KDoubleNumInput* instPointer,double max);

/** 

*/
double kde_KDoubleNumInput_maxValue(kde_KDoubleNumInput* instPointer);

/** 
 Specifies the number of digits to use.
     
*/
void kde_KDoubleNumInput_setPrecision(kde_KDoubleNumInput* instPointer,int precision);

/** 
 Sets the special value text. If set, the spin box will display
 this text instead of the numeric value whenever the current
 value is equal to @ref #minVal(). Typically this is used for indicating
 that the choice has a special (default) meaning.
     
*/
void kde_KDoubleNumInput_setSpecialValueText(kde_KDoubleNumInput* instPointer,qt_QString * text);

/** 
 Sets the value of the control.
     
*/
void kde_KDoubleNumInput_setValue(kde_KDoubleNumInput* instPointer,double arg1);

/** 
 Sets the suffix to be displayed to @p suffix. Use QString::null to disable
 this feature. Note that the suffix is attached to the value without any
 spacing. So if you prefer to display a space separator, set suffix
 to something like " cm".

*/
void kde_KDoubleNumInput_setSuffix(kde_KDoubleNumInput* instPointer,qt_QString * suffix);

/** 
 Sets the prefix to be displayed to @p prefix. Use QString::null to disable
 this feature. Note that the prefix is attached to the value without any
 spacing.

*/
void kde_KDoubleNumInput_setPrefix(kde_KDoubleNumInput* instPointer,qt_QString * prefix);
void kde_KDoubleNumInput_resetEditBox(kde_KDoubleNumInput* instPointer);

#endif
