/***************************************************************************
                            kde_KAboutDialog.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KABOUTDIALOG
#define KDE_KABOUTDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A @ref KDialogBase with predefined main widget.

 As a @ref KDialogBase it uses your application wide settings
 for @ref KDialogBase
 objects (base frame tiles, main frame tiles etc).
 To use it, simply create a KAboutDialog object, set all (or some) of its
 properties and show it. Do not derive it to create your own about dialog
 until you need some cool features that are unsupported and you have
 contacted me to add them.

 The dialog can be created using two different constructors. The
 difference between these constructors is the available components that
 can be used to build the contents of the dialog. The first (Constructor I)
 provides a number of easy to use methods. Basically it allows you
 to add the components of choice, and the components are placed in a
 predefined layout. You do not have to plan the layout. Everything is
 taken care of.

 The second constructor (Constructor II) works in quite the same manner
 as the first, but you have better control on where the components
 are postioned in the layout and you have access to an extended number
 of components you can install such as titles, product information,
 a tabbed pages (where you can display rich text with url links) and
 a person (developer) information field. The "About KDE" dialog box is
 created with Constructor II.

 For the derived features, see the basic class @ref KDialogBase.

 @author Mirko Boehm (mirko@kde.org) and Espen Sand (espensa@online.no)

 @short 
 A @ref KDialogBase with predefined main widget.
*/
#define KABOUTDIALOG_AbtPlain	0x0001
#define KABOUTDIALOG_AbtTabbed	0x0002
#define KABOUTDIALOG_AbtTitle	0x0004
#define KABOUTDIALOG_AbtImageLeft	0x0008
#define KABOUTDIALOG_AbtImageRight	0x0010
#define KABOUTDIALOG_AbtImageOnly	0x0020
#define KABOUTDIALOG_AbtProduct	0x0040
#define KABOUTDIALOG_AbtKDEStandard	KABOUTDIALOG_AbtTabbed|KABOUTDIALOG_AbtTitle|KABOUTDIALOG_AbtImageLeft
#define KABOUTDIALOG_AbtAppStandard	KABOUTDIALOG_AbtTabbed|KABOUTDIALOG_AbtTitle|KABOUTDIALOG_AbtProduct
#define KABOUTDIALOG_AbtImageAndTitle	KABOUTDIALOG_AbtPlain|KABOUTDIALOG_AbtTitle|KABOUTDIALOG_AbtImageOnly

/** 
 The standard Qt constructor (Constructor I).

 Add components with the following methods:
  @ref setLogo(), @ref setAuthor(), @ref setMaintainer(),
   @ref addContributor(), or @ref setVersion().
 The dialog will be laid out automatically.
     
*/
kde_KAboutDialog * kde_new_KAboutDialog(qt_QWidget * parent, char* name, int modal);

/** 
 The extended constructor. (Constructor II).

 Add components with the methods:
  @ref setTitle(), @ref setImage(), @ref setImageBackgroundColor(),
  @ref setImageFrame(), @ref setProduct(), @ref addTextPage(),
  @ref addContainerPage(), @ref addContainer(), or @ref addPage().

    
*/
kde_KAboutDialog * kde_new_KAboutDialog1(int dialogLayout, qt_QString * caption, int buttonMask, int defaultButton, qt_QWidget * parent, char* name, int modal, int separator, qt_QString * user1, qt_QString * user2, qt_QString * user3);

/** 
 Adjusts the dialog.

 You can call this method after you have set up all
 the contents but it is not required. It is done automatically when
 @ref show() is executed.
   
*/
void kde_KAboutDialog_adjust(kde_KAboutDialog* instPointer);

/** 
 Makes a modeless (modal = false in constructor) dialog visible.

 If you reimplement this method make sure you run it
 in the new method (e.g., @ref show()). Reimplemented
 from @ref KDialogBase.
   
*/
void kde_KAboutDialog_show(kde_KAboutDialog* instPointer);

/** 
 Makes a modeless (modal = false in constructor) dialog visible.

 If you reimplmement this method make sure you run it
 in the new method (i.e., @ref show( parent )).

*/
void kde_KAboutDialog_show1(kde_KAboutDialog* instPointer,qt_QWidget * centerParent);

/** 
 (Constructor II only)
 Sets a title (not caption) in the uppermost area of the dialog.

*/
void kde_KAboutDialog_setTitle(kde_KAboutDialog* instPointer,qt_QString * title);

/** 
 (Constructor II only)
 Define an image to be shown in the dialog. The position is dependent
 on the @p dialogLayout in the constructor

*/
void kde_KAboutDialog_setImage(kde_KAboutDialog* instPointer,qt_QString * fileName);

/** 
 (Constructor II only)
 The image has a minimum size, but is centered within an area if the
 dialog box is enlarged by the user. You set the background color
 of the area with this method.

*/
void kde_KAboutDialog_setImageBackgroundColor(kde_KAboutDialog* instPointer,qt_QColor * color);

/** 
 (Constructor II only)
 Enables or disables a frame around the image. The frame is, by default,
 enabled in the constructor

*/
void kde_KAboutDialog_setImageFrame(kde_KAboutDialog* instPointer,int state);

/** 
 (Constructor II only)
 Prints the application name, KDE version, author, a copyright sign
 and a year string. To the left of the text the standard application
 icon is displayed.

*/
void kde_KAboutDialog_setProduct(kde_KAboutDialog* instPointer,qt_QString * appName, qt_QString * version, qt_QString * author, qt_QString * year);

/** 
 (Constructor II only)
 Adds a text page to a tab box. The text can be regular text or
 rich text. The rich text can contain URLs and mail links.

*/
qt_QFrame* kde_KAboutDialog_addTextPage(kde_KAboutDialog* instPointer,qt_QString * title, qt_QString * text, int richText, int numLines);

/** 
 (Constructor II only)
 Adds a license page to a tab box.

*/
qt_QFrame* kde_KAboutDialog_addLicensePage(kde_KAboutDialog* instPointer,qt_QString * title, qt_QString * text, int numLines);

/** 
 (Constructor II only)
 Adds a container to a tab box. You can add text and images to a
 container.

*/
kde_KAboutContainer* kde_KAboutDialog_addContainerPage(kde_KAboutDialog* instPointer,qt_QString * title, int childAlignment, int innerAlignment);

/** 
 (Constructor II only)
 Adds a container inside a QScrollView to a tab box. You can add text
 and images to a container.

*/
kde_KAboutContainer* kde_KAboutDialog_addScrolledContainerPage(kde_KAboutDialog* instPointer,qt_QString * title, int childAlignment, int innerAlignment);

/** 
 (Constructor II only)
 Adds a container. You can add text and images to a container.

*/
kde_KAboutContainer* kde_KAboutDialog_addContainer(kde_KAboutDialog* instPointer,int childAlignment, int innerAlignment);

/** 
 (Constructor II only)
 Adds an empty page to a tab box.

*/
qt_QFrame* kde_KAboutDialog_addPage(kde_KAboutDialog* instPointer,qt_QString * title);

/** 
 (Constructor I only)
 Sets the image as the application logo.
   
*/
void kde_KAboutDialog_setLogo(kde_KAboutDialog* instPointer,qt_QPixmap * arg1);

/** 
 (Constructor I only)
 Sets the author's name and email address.
   
*/
void kde_KAboutDialog_setAuthor(kde_KAboutDialog* instPointer,qt_QString * name, qt_QString * email, qt_QString * url, qt_QString * work);

/** 
 (Constructor I only)
 Sets the maintainer's name and email address.
   
*/
void kde_KAboutDialog_setMaintainer(kde_KAboutDialog* instPointer,qt_QString * name, qt_QString * email, qt_QString * url, qt_QString * work);

/** 
 (Constructor I only)
 Show this person as one of the major contributors.
   
*/
void kde_KAboutDialog_addContributor(kde_KAboutDialog* instPointer,qt_QString * name, qt_QString * email, qt_QString * url, qt_QString * work);

/** 
 (Constructor I only)
 Sets the text describing the version.
   
*/
void kde_KAboutDialog_setVersion(kde_KAboutDialog* instPointer,qt_QString * name);

/** 
 Create a modal dialog with an image in the upper area with a
 URL link below.
   
*/
void kde_KAboutDialog_imageURL( qt_QWidget * parent, qt_QString * caption, qt_QString * path, qt_QColor * imageColor, qt_QString * url);

/** 
 Connected to widget->sendEmail.
   
*/
void kde_KAboutDialog_sendEmailSlot(kde_KAboutDialog* instPointer,qt_QString * name, qt_QString * email);

/** 
 Open this URL.
   
*/
void kde_KAboutDialog_openURLSlot(kde_KAboutDialog* instPointer,qt_QString * url);

/** 
 (Constructor II only)
 Tells the position of the mouse cursor when the left mouse button
 is pressed above an image
   
*/
void kde_KAboutDialog_mouseTrackSlot(kde_KAboutDialog* instPointer,int mode, qt_QMouseEvent* e);

#endif
