/***************************************************************************
                            kde_HTMLLinkElement.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLLINKELEMENT
#define KDE_HTMLLINKELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The <code> LINK </code> element specifies a link to an external
 resource, and defines this document's relationship to that resource
 (or vice versa). See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#edef-LINK">
 LINK element definition </a> in HTML 4.0.

 
 @short 
 The <code> LINK </code> element specifies a link to an external
 resource, and defines this document's relationship to that resource
 (or vice versa).
*/
kde_HTMLLinkElement * kde_new_HTMLLinkElement();
kde_HTMLLinkElement * kde_new_HTMLLinkElement1(kde_HTMLLinkElement* other);
kde_HTMLLinkElement * kde_new_HTMLLinkElement2(kde_DOMNode* other);
void kde_del_HTMLLinkElement( kde_HTMLLinkElement* p );

/** 
 Enables/disables the link. This is currently only used for
 style sheet links, and may be used to activate or deactivate
 style sheets.

     
*/
int kde_HTMLLinkElement_disabled(kde_HTMLLinkElement* instPointer);

/** 
 see @ref disabled
     
*/
void kde_HTMLLinkElement_setDisabled(kde_HTMLLinkElement* instPointer,int arg1);

/** 
 The character encoding of the resource being linked to. See the
 <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-charset">
 charset attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLLinkElement_charset(kde_HTMLLinkElement* instPointer);

/** 
 see @ref charset
     
*/
void kde_HTMLLinkElement_setCharset(kde_HTMLLinkElement* instPointer,kde_DOMString* arg1);

/** 
 The URI of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-href">
 href attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLLinkElement_href(kde_HTMLLinkElement* instPointer);

/** 
 see @ref href
     
*/
void kde_HTMLLinkElement_setHref(kde_HTMLLinkElement* instPointer,kde_DOMString* arg1);

/** 
 Language code of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-hreflang">
 hreflang attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLLinkElement_hreflang(kde_HTMLLinkElement* instPointer);

/** 
 see @ref hreflang
     
*/
void kde_HTMLLinkElement_setHreflang(kde_HTMLLinkElement* instPointer,kde_DOMString* arg1);

/** 
 Designed for use with one or more target media. See the <a
 href="http://www.w3.org/TR/REC-html40/present/styles.html#adef-media">
 media attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLLinkElement_media(kde_HTMLLinkElement* instPointer);

/** 
 see @ref media
     
*/
void kde_HTMLLinkElement_setMedia(kde_HTMLLinkElement* instPointer,kde_DOMString* arg1);

/** 
 Forward link type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-rel">
 rel attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLLinkElement_rel(kde_HTMLLinkElement* instPointer);

/** 
 see @ref rel
     
*/
void kde_HTMLLinkElement_setRel(kde_HTMLLinkElement* instPointer,kde_DOMString* arg1);

/** 
 Reverse link type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-rev">
 rev attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLLinkElement_rev(kde_HTMLLinkElement* instPointer);

/** 
 see @ref rev
     
*/
void kde_HTMLLinkElement_setRev(kde_HTMLLinkElement* instPointer,kde_DOMString* arg1);

/** 
 Frame to render the resource in. See the <a
 href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">
 target attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLLinkElement_target(kde_HTMLLinkElement* instPointer);

/** 
 see @ref target
     
*/
void kde_HTMLLinkElement_setTarget(kde_HTMLLinkElement* instPointer,kde_DOMString* arg1);

/** 
 Advisory content type. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-type-A">
 type attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLLinkElement_type(kde_HTMLLinkElement* instPointer);

/** 
 see @ref type
     
*/
void kde_HTMLLinkElement_setType(kde_HTMLLinkElement* instPointer,kde_DOMString* arg1);

/** 
 Introduced in DOM Level 2
 This method is from the LinkStyle interface

 The style sheet.
     
*/
kde_StyleSheet* kde_HTMLLinkElement_sheet(kde_HTMLLinkElement* instPointer);

#endif
