/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * kanji_conv.h
 *
 * Copyright (C) 2000 Takuo Kitame <kitame@gnome.gr.jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KANJI_CONV_H__
#define __KANJI_CONV_H__

#define KANJI_SJIS "Shift_JIS"
#define KANJI_EUC "EUC-JP"
#define KANJI_JIS "ISO-2022-JP"

enum
{
	KC_ASCII,
	KC_EUC,
	KC_JIS,
	KC_SJIS,
	EUCORSJIS
};

char *kanji_conv(const char *str, const char *dstset, const char *srcset);
char *kanji_conv_auto(const char *str, const char *dstset);
char *kanji_conv_to_locale(const char *str);

void kanji_conv_to_locale_s(char **str);
void kanji_conv_auto_s(char **str, const char *dstset);

#endif
