/***************************************
 Blink stuff, handle other timed events
 (c) 1999 Jeremy Wise
 GnomeICU
****************************************/

#include "common.h"
#include "applet.h"
#include "flash.h"
#include "gnomeicu.h"
#include "icons.h"

/*** Local function declarations ***/
void set_widget_color(GtkWidget* w, GdkColor rgb);
void set_clist_icon(GtkWidget *clist, CONTACT_PTR contact, GdkPixmap *pixmap, GdkBitmap *bitmap);

static GdkColor red = { 0, 32000, 0, 0 };
static GdkColor black = { 0, 0, 0, 0 };

/*** Global functions ***/
guint flash_messages( void )
{
	static gboolean flash = FALSE;
	static char prev_status = 0;
	int have_message = 0;

	GtkWidget *clist;
	GSList *contact;

	gboolean have_online_msg = FALSE, have_offline_msg = FALSE;
	static gboolean had_online_msg = FALSE, had_offline_msg = FALSE;
	gboolean have_not_msg = FALSE;
	static gboolean had_not_msg = FALSE;

	flash = !flash;

	if( (Current_Status & 0xffff) == STATUS_DND )
		flash = 1;

	contact = Contacts;

	while( contact != NULL )
	{
/*		gchar *wintitle = NULL;
		if( kontakt->chat_away == -1 )
		{
			wintitle = g_strdup_printf( _("GnomeICU: %s, %s"), ( strlen( our_info->nick ) ? our_info->nick : _("User") ), kontakt->nick );
			gtk_window_set_title( GTK_WINDOW( kontakt->chat_window ), wintitle );
			kontakt->chat_away = 0;
                        g_free( wintitle );
		}

		if( kontakt->chat_away > 0 )
		{
			if( kontakt->chat_sok )
			{
				int time_away = time(NULL) - kontakt->chat_away;
				wintitle = g_strdup_printf( _("GnomeICU: %s, %s: User is away [%02d:%02d:%02d]"),
				         ( strlen( our_info->nick ) ? our_info->nick : _("User") ), kontakt->nick,
				         time_away / 3600, (time_away % 3600) / 60,
				         time_away % 60 );
				gtk_window_set_title( GTK_WINDOW( kontakt->chat_window ), wintitle );
                                g_free( wintitle );
			}
		}
*/
		if( g_slist_length( kontakt->stored_messages ) )
		{
			if( kontakt->inlist == FALSE )
			{
				clist = MainData->lb_userwin_notinlist;
				have_not_msg = TRUE;
			}
			else if( kontakt->status == STATUS_OFFLINE )
			{
				clist = MainData->lb_userwin_offline;
				have_offline_msg = TRUE;
			}
			else
			{
				clist = MainData->lb_userwin_online;
				have_online_msg = TRUE;
			}

			have_message = TRUE;
			if( flash == FALSE )
			{
				set_clist_icon( clist, kontakt, icon_blank_pixmap, icon_blank_bitmap );
			}
			else
			{
                            switch( ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type )
                            {
                            case MESSAGE_TEXT:
                            default:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_message_pixmap,
                                                icon_message_bitmap );
                                break;
                            case MESSAGE_CHAT_REQ:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_chat_pixmap,
                                                icon_chat_bitmap );
                                break;
                            case MESSAGE_URL:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_url_pixmap,
                                                icon_url_bitmap );
                                break;
                            case MESSAGE_CONT_LIST:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_contact_pixmap,
                                                icon_contact_bitmap );
                                break;
                            case MESSAGE_AUTH_REQ:
                            case MESSAGE_USER_ADD:
                            case MESSAGE_USER_AUTHD:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_auth_pixmap,
                                                icon_auth_bitmap );
                                break;
                            case MESSAGE_FILE_REQ:
                                set_clist_icon( clist,
                                                kontakt,
                                                icon_file_pixmap,
                                                icon_file_bitmap );
                                break;
                            }
			}
		}
                
		contact = contact->next;
	}

	if( have_message )
	{
		applet_update( Current_Status, flash );
	}

	if( have_message != prev_status )
	{
		prev_status = have_message;
		gtk_window_set_title (GTK_WINDOW (MainData->window),
		                      have_message ? _("GnomeICU: Msgs") : "GnomeICU");
	}

	if( had_online_msg != have_online_msg )
	{
		had_online_msg = have_online_msg;
		if( have_online_msg )
			set_widget_color( MainData->head_online, red );
		else
			set_widget_color( MainData->head_online, black );
	}

	if( had_offline_msg != have_offline_msg )
	{
		had_offline_msg = have_offline_msg;
		if( have_offline_msg )
			set_widget_color( MainData->head_offline, red );
		else
			set_widget_color( MainData->head_offline, black );
	}

	if( had_not_msg != have_not_msg )
	{
		had_not_msg = have_not_msg;
		if( have_not_msg )
			set_widget_color( MainData->head_notinlist, red );
		else
			set_widget_color( MainData->head_notinlist, black );
	}

	return TRUE;
}

/*** Local functions ***/

void set_clist_icon(GtkWidget *clist, CONTACT_PTR contact,
                    GdkPixmap *icon_pixmap, GdkBitmap *icon_bitmap)
{
    GtkWidget *window, *pixmap;
    
    gtk_clist_set_pixmap( GTK_CLIST( clist ),
                          contact->lb_index, 0,
                          icon_pixmap,
                          icon_bitmap );

    /* Also update shortcut for the contact */
    if( GTK_IS_WIDGET( contact->detached_window ) ) 
    {
        window = contact->detached_window;
        pixmap = gtk_object_get_data( GTK_OBJECT( window ), "pixmap" );
        gtk_pixmap_set( GTK_PIXMAP( pixmap ), icon_pixmap, icon_bitmap );
    }
}

void set_widget_color(GtkWidget* w, GdkColor rgb)
{
	GtkStyle* style;

	gtk_widget_ensure_style(w);
	style = gtk_style_copy(w->style);
	style->fg[ GTK_STATE_NORMAL ] = rgb;
	gtk_widget_set_style(w, style);

	gtk_style_unref(style);
}
