/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * log.c - assorted utilities for maintaining the logs
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include "logfile/logfile.h"
#include "utils.h"
#include "types.h"
#include "log.h"
#include "support.h"

extern statetype state;
extern preferencestype preferences;

/* extracted name of the log from filename
   returned string should be free'd */
gchar *logname(gchar *filename)
{
	gchar *logname;
	gchar **split = g_strsplit(filename, ".", 1);
	logname = g_strdup(split[0]);
	g_strfreev(split);
	return(logname);
}

/* prepend qsos to the log */
gint fillin_clist(LOGDB *handle, qso_t q[], gpointer arg) {
	logtype *logw = (logtype *)arg;
	gint newrow;

	state.qsos++;
	logw->qsos++;
	q[NR] = g_strdup_printf("%d", logw->qsos);
	newrow = gtk_clist_prepend((GtkCList*)(logw->clist), q);
	if (preferences.logcolor == 1) setcallstyle(logw->clist, newrow, preferences.themecolor);
	return 0;
}

/* create a new struct for a log */
logtype *new_logwindow(gint id)
{
	logtype *newlog;

	newlog = g_new0(struct logtype, 1);
	newlog->id = id;
	newlog->scrolledwindow = NULL;
	newlog->clist = NULL;
	newlog->label = NULL;
	newlog->logname = NULL;
	newlog->logchanged = FALSE;
	newlog->qsos = 0;
	return(newlog);
}

/* look for logs in dir */
GString *getlogs(gchar *dir)
{
	gchar *command;
	FILE *ls;
	gint c, err;
	GString *logs = g_string_new("");

	err = chdir(dir);
	if (err == -1)
		g_error(_("Changing to log directory %s: %s"), dir, g_strerror(errno));
	command = g_strdup("/bin/ls -1 *\\.xlog");
	if ((ls = popen(command, "r")) == NULL)
		g_error(_("Popen failed: %s"), g_strerror(errno));
	else 
		while((c = getc(ls)) != EOF) 
			g_string_append_c(logs, c);
	pclose(ls);
	chdir(g_get_home_dir());
	return (logs);
}
