/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import sun.plugin.resources.ResourceHandler;

public class ProgressDialog
extends JFrame {
    private long upTime = 0L;
    private long minTime = 2000L;
    private JLabel fileLabel;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private String percentStr;
    private String titleStr;
    private String filename;
    private String labelStr;
    private boolean iconified = false;

    public void init(String string) {
        this.filename = string;
        this.titleStr = ResourceHandler.getMessage("progress_dialog.downloading");
        if (string.lastIndexOf(47) != -1) {
            this.filename = string.substring(string.lastIndexOf(47) + 1);
        }
        if (string.lastIndexOf(":/") != -1) {
            String string2 = string.trim().substring(0, string.lastIndexOf(":/"));
            String string3 = string2.substring(string2.lastIndexOf(58) + 1);
            if (string3.equals("http") || string3.equals("https")) {
                string2 = string.substring(string.lastIndexOf("://") + 3);
                string2 = string2.substring(0, string2.indexOf(47));
                this.labelStr = this.filename + " " + ResourceHandler.getMessage("progress_dialog.from") + " " + string3 + "://" + string2 + "/";
            } else if (string3.trim().equals("file")) {
                string2 = string.substring(string.lastIndexOf(":/") + 2);
                string2 = string2.substring(0, string2.indexOf(47));
                this.labelStr = this.filename + " " + ResourceHandler.getMessage("progress_dialog.from") + " " + string3 + ":/" + string2 + "/";
            }
        }
        if (this.labelStr == null) {
            this.labelStr = this.filename;
        }
        this.createComponents();
    }

    private void createComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createGlue());
        Dimension dimension = new Dimension(1, 5);
        jPanel.add(Box.createRigidArea(dimension));
        this.fileLabel = new JLabel(this.labelStr);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.fileLabel);
        jPanel2.add(Box.createGlue());
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(dimension));
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setForeground(new Color(153, 153, 204));
        jPanel.add(this.progressBar);
        jPanel.add(Box.createGlue());
        JButton jButton = new JButton(ResourceHandler.getMessage("progress_dialog.dismiss_button"));
        jButton.setMnemonic(jButton.getText().charAt(0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressDialog.this.setVisible(false);
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createGlue());
        jPanel3.add(jButton);
        jPanel3.add(Box.createGlue());
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(dimension));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.add(Box.createRigidArea(new Dimension(20, 1)));
        jPanel4.add(jPanel);
        jPanel4.add(Box.createRigidArea(new Dimension(20, 1)));
        this.setContentPane(jPanel4);
        this.setTitle(this.titleStr);
        this.setSize(500, 150);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ProgressDialog.this.setVisible(false);
            }

            public void windowIconified(WindowEvent windowEvent) {
                ProgressDialog.this.percentStr = ProgressDialog.this.progressBar.getString();
                if (ProgressDialog.this.percentStr != null) {
                    ProgressDialog.this.setTitle("(" + ProgressDialog.this.percentStr + ") - " + ProgressDialog.this.filename);
                }
                ProgressDialog.this.iconified = true;
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                ProgressDialog.this.setTitle(ProgressDialog.this.titleStr);
                ProgressDialog.this.iconified = false;
            }
        });
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = this.getSize();
        this.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
        this.setVisible(true);
        this.upTime = System.currentTimeMillis();
    }

    public void addBytes(int n) {
        this.progressBar.setValue(n);
        if (this.iconified) {
            this.percentStr = this.progressBar.getString();
            this.setTitle("(" + this.percentStr + ") - " + this.filename);
        }
    }

    public void setTotal(int n) {
        this.progressBar.setMaximum(n);
    }

    public void close() {
        this.progressBar.setValue(this.progressBar.getMaximum());
        while (System.currentTimeMillis() - this.upTime < this.minTime) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setVisible(false);
    }

    public void reopen() {
        this.setVisible(true);
        this.progressBar.setValue(1);
        this.upTime = System.currentTimeMillis();
    }
}

