/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import sun.plugin.cache.JarCacheTable;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.UserProfile;

public class JarCacheViewer
extends JFrame {
    private JarCacheTable viewerTable;
    private static String cacheLocation;

    public JarCacheViewer(String string) {
        if (string != null) {
            cacheLocation = string;
        }
        Container container = this.getContentPane();
        this.setTitle(ResourceHandler.getMessage("cache_viewer.title"));
        this.viewerTable = new JarCacheTable();
        JScrollPane jScrollPane = new JScrollPane(this.viewerTable);
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        JButton jButton = new JButton(ResourceHandler.getMessage("cache_viewer.refresh"));
        JButton jButton2 = new JButton(ResourceHandler.getMessage("cache_viewer.remove"));
        JButton jButton3 = new JButton(ResourceHandler.getMessage("cache_viewer.close"));
        jButton.setMnemonic(jButton.getText().charAt(0));
        jButton2.setMnemonic(jButton2.getText().charAt(0));
        jButton3.setMnemonic(jButton3.getText().charAt(0));
        jPanel.add(jButton);
        jPanel.add(new Label("    "));
        jPanel.add(jButton2);
        jPanel.add(new Label("    "));
        jPanel.add(jButton3);
        container.add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JarCacheViewer.this.dispose();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.viewerTable.refresh();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.viewerTable.removeRows();
            }
        };
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.dispose();
            }
        };
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener2);
        jButton3.addActionListener(actionListener3);
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(1);
        this.getRootPane().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JarCacheViewer.this.viewerTable.adjustColumnSize((Container)componentEvent.getComponent());
            }
        });
        this.setSize(800, 400);
        this.setVisible(true);
    }

    public static String getCacheLocation() {
        if (cacheLocation != null) {
            return cacheLocation;
        }
        return UserProfile.getCommonCacheDir();
    }

    public static void main(String[] stringArray) {
        JarCacheViewer jarCacheViewer = new JarCacheViewer(stringArray[0]);
    }
}

