/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.util.BitArray;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNameInterface;

public class IPAddressName
implements GeneralNameInterface {
    private byte[] address;
    private static final int MASKSIZE = 16;
    private static final int IN6ADDRSZ = 16;
    private static final int INT16SZ = 2;
    private static final int INADDRSZ = 4;

    public IPAddressName(DerValue derValue) throws IOException {
        this(derValue.getOctetString());
    }

    public IPAddressName(byte[] byArray) throws IOException {
        if (byArray.length != 4 && byArray.length != 8 && byArray.length != 16 && byArray.length != 32) {
            throw new IOException("Invalid IPAddressName");
        }
        this.address = byArray;
    }

    public IPAddressName(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("IPAddressName cannot be null");
        }
        if (string.charAt(string.length() - 1) == '/') {
            throw new IOException("Invalid IPAddress " + string);
        }
        if (string.indexOf(":") >= 0) {
            this.parseIPv6(string);
        } else if (string.indexOf(".") >= 0) {
            int n2 = string.indexOf(47);
            if (n2 == -1) {
                this.address = IPAddressName.ipv4_getByteArray(string);
                if (this.address == null) {
                    throw new IOException("Invalid IPAddress" + string);
                }
            } else {
                this.address = new byte[8];
                byte[] byArray = IPAddressName.ipv4_getByteArray(string.substring(n2 + 1));
                byte[] byArray2 = IPAddressName.ipv4_getByteArray(string.substring(0, n2));
                if (byArray == null || byArray2 == null) {
                    throw new IOException("Invalid IPAddress" + string);
                }
                System.arraycopy(byArray2, 0, this.address, 0, 4);
                System.arraycopy(byArray, 0, this.address, 4, 4);
            }
        } else {
            throw new IOException("Invalid IPAddressName " + string);
        }
    }

    private void parseIPv6(String string) throws IOException {
        Object object;
        int n2 = string.indexOf(47);
        if (n2 >= 0) {
            this.address = new byte[32];
            object = IPAddressName.ipv6_getByteArray(string.substring(0, n2));
            if (object == null) {
                throw new IOException("Invalid IPAddress" + string);
            }
            System.arraycopy(object, 0, this.address, 0, 16);
        } else {
            this.address = IPAddressName.ipv6_getByteArray(string);
            if (this.address == null) {
                throw new IOException("Invalid IPAddress" + string);
            }
        }
        if (n2 >= 0) {
            object = string.substring(n2 + 1);
            int n3 = Integer.parseInt((String)object);
            if (n3 > 128) {
                throw new IOException("Prefix may not be longer than 128");
            }
            BitArray bitArray = new BitArray(128);
            int n4 = 0;
            while (n4 < n3) {
                bitArray.set(n4, true);
                ++n4;
            }
            byte[] byArray = bitArray.toByteArray();
            int n5 = 0;
            while (n5 < 16) {
                this.address[16 + n5] = byArray[n5];
                ++n5;
            }
        }
    }

    public int getType() {
        return 7;
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOctetString(this.address);
    }

    public String toString() {
        try {
            return "IPAddress: " + this.getName();
        }
        catch (IOException iOException) {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            return "IPAddress: " + hexDumpEncoder.encodeBuffer(this.address);
        }
    }

    public String getName() throws IOException {
        String string = "";
        if (this.address.length == 4 || this.address.length == 8) {
            string = string + (this.address[0] & 0xFF) + "." + (this.address[1] & 0xFF) + "." + (this.address[2] & 0xFF) + "." + (this.address[3] & 0xFF);
            if (this.address.length == 8) {
                string = string + "/" + (this.address[4] & 0xFF) + "." + (this.address[5] & 0xFF) + "." + (this.address[6] & 0xFF) + "." + (this.address[7] & 0xFF);
            }
        } else if (this.address.length == 16 || this.address.length == 32) {
            String string2 = "";
            int n2 = this.address.length;
            int n3 = 0;
            while (n3 < 8) {
                int n4 = ((this.address[n3 * 2] & 0xFF) << 8) + (this.address[n3 * 2 + 1] & 0xFF);
                String string3 = Integer.toHexString(n4);
                if (string3.length() > 4) {
                    string3 = string3.substring(string3.length() - 4, string3.length());
                }
                string2 = n3 == 7 ? (n2 == 16 ? "" : "/") : ":";
                string = string + string3 + string2;
                ++n3;
            }
            if (n2 == 32) {
                byte[] byArray = new byte[16];
                int n5 = 16;
                while (n5 < 32) {
                    byArray[n5 - 16] = this.address[n5];
                    ++n5;
                }
                BitArray bitArray = new BitArray(128, byArray);
                int n6 = 0;
                while (n6 < 128) {
                    if (!bitArray.get(n6)) break;
                    ++n6;
                }
                string = string + n6;
                while (n6 < 128) {
                    if (bitArray.get(n6)) {
                        throw new IOException("Invalid IPv6 subdomain - set bit " + n6 + " not contiguous");
                    }
                    ++n6;
                }
            }
        } else {
            throw new IOException("invalid length " + this.address.length);
        }
        return string;
    }

    public byte[] getBytes() {
        return (byte[])this.address.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPAddressName)) {
            return false;
        }
        byte[] byArray = ((IPAddressName)object).getBytes();
        if (byArray.length != this.address.length) {
            return false;
        }
        if (this.address.length == 8 || this.address.length == 32) {
            int n2 = this.address.length / 2;
            byte[] byArray2 = new byte[n2];
            byte[] byArray3 = new byte[n2];
            int n3 = 0;
            while (n3 < n2) {
                byArray2[n3] = (byte)(this.address[n3] & this.address[n3 + n2]);
                byArray3[n3] = (byte)(byArray[n3] & byArray[n3 + n2]);
                if (byArray2[n3] != byArray3[n3]) {
                    return false;
                }
                ++n3;
            }
            int n4 = n2;
            while (n4 < this.address.length) {
                if (this.address[n4] != byArray[n4]) {
                    return false;
                }
                ++n4;
            }
            return true;
        }
        return Arrays.equals(byArray, this.address);
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.address.length) {
            n2 += this.address[n3] * n3;
            ++n3;
        }
        return n2;
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        if (generalNameInterface == null) {
            n2 = -1;
        } else if (generalNameInterface.getType() != 7) {
            n2 = -1;
        } else if (((IPAddressName)generalNameInterface).equals(this)) {
            n2 = 0;
        } else {
            byte[] byArray = ((IPAddressName)generalNameInterface).getBytes();
            if (byArray.length == 4 && this.address.length == 4) {
                n2 = 3;
            } else if (byArray.length == 8 && this.address.length == 8 || byArray.length == 32 && this.address.length == 32) {
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = false;
                boolean bl5 = false;
                int n3 = this.address.length / 2;
                int n4 = 0;
                while (n4 < n3) {
                    if ((byte)(this.address[n4] & this.address[n4 + n3]) != this.address[n4]) {
                        bl4 = true;
                    }
                    if ((byte)(byArray[n4] & byArray[n4 + n3]) != byArray[n4]) {
                        bl5 = true;
                    }
                    if ((byte)(this.address[n4 + n3] & byArray[n4 + n3]) != this.address[n4 + n3] || (byte)(this.address[n4] & this.address[n4 + n3]) != (byte)(byArray[n4] & this.address[n4 + n3])) {
                        bl2 = false;
                    }
                    if ((byte)(byArray[n4 + n3] & this.address[n4 + n3]) != byArray[n4 + n3] || (byte)(byArray[n4] & byArray[n4 + n3]) != (byte)(this.address[n4] & byArray[n4 + n3])) {
                        bl3 = false;
                    }
                    ++n4;
                }
                n2 = bl4 || bl5 ? (bl4 && bl5 ? 0 : (bl4 ? 2 : 1)) : (bl2 ? 1 : (bl3 ? 2 : 3));
            } else if (byArray.length == 8 || byArray.length == 32) {
                int n5 = 0;
                int n6 = byArray.length / 2;
                while (n5 < n6) {
                    if ((this.address[n5] & byArray[n5 + n6]) != byArray[n5]) break;
                    ++n5;
                }
                n2 = n5 == n6 ? 2 : 3;
            } else if (this.address.length == 8 || this.address.length == 32) {
                int n7 = 0;
                int n8 = this.address.length / 2;
                while (n7 < n8) {
                    if ((byArray[n7] & this.address[n7 + n8]) != this.address[n7]) break;
                    ++n7;
                }
                n2 = n7 == n8 ? 1 : 3;
            } else {
                n2 = 3;
            }
        }
        return n2;
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("subtreeDepth() not defined for IPAddressName");
    }

    static byte[] ipv6_getByteArray(String string) {
        int n2;
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[16];
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        if (byArray[n4] == 58 && byArray[++n4] != 58) {
            return null;
        }
        boolean bl2 = false;
        int n6 = 0;
        while (n4 < byArray.length) {
            byte by;
            if ((n2 = Character.digit((char)(by = byArray[n4++]), 16)) != -1) {
                n6 <<= 4;
                if ((n6 |= n2) > 65535) {
                    return null;
                }
                bl2 = true;
                continue;
            }
            if (by == 58) {
                if (!bl2) {
                    if (n3 != -1) {
                        return null;
                    }
                    n3 = n5;
                    continue;
                }
                if (n4 == byArray.length) {
                    return null;
                }
                if (n5 + 2 > 16) {
                    return null;
                }
                byArray2[n5++] = (byte)(n6 >> 8 & 0xFF);
                byArray2[n5++] = (byte)(n6 & 0xFF);
                bl2 = false;
                n6 = 0;
                continue;
            }
            if (by == 46 && n5 + 4 <= 16) {
                byte[] byArray3 = IPAddressName.ipv4_getByteArray(string.substring(n4));
                int n7 = 0;
                while (n7 < 4) {
                    byArray2[n5++] = byArray3[n7];
                    ++n7;
                }
                bl2 = false;
                break;
            }
            return null;
        }
        if (bl2) {
            if (n5 + 2 > 16) {
                return null;
            }
            byArray2[n5++] = (byte)(n6 >> 8 & 0xFF);
            byArray2[n5++] = (byte)(n6 & 0xFF);
        }
        if (n3 != -1) {
            n2 = n5 - n3;
            if (n5 == 16) {
                return null;
            }
            n4 = 1;
            while (n4 <= n2) {
                byArray2[16 - n4] = byArray2[n3 + n2 - n4];
                byArray2[n3 + n2 - n4] = 0;
                ++n4;
            }
            n5 = 16;
        }
        if (n5 != 16) {
            return null;
        }
        return byArray2;
    }

    static byte[] ipv4_getByteArray(String string) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = string.getBytes();
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray2.length) {
            byte by;
            if (Character.isDigit((char)(by = byArray2[n3++]))) {
                byArray[n4] = (byte)(byArray[n4] * 10 + (Character.digit((char)by, 10) & 0xFF));
                if (byArray[n4] > 255) {
                    return null;
                }
                if (bl2) continue;
                if (++n2 > 4) {
                    return null;
                }
                bl2 = true;
                continue;
            }
            if (by == 46 && bl2) {
                if (n2 == 4) {
                    return null;
                }
                byArray[++n4] = 0;
                bl2 = false;
                continue;
            }
            return null;
        }
        if (n2 < 4) {
            return null;
        }
        return byArray;
    }
}

