/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.security.action.GetPropertyAction;

public abstract class Transport {
    static final int logLevel = LogStream.parseLevel(Transport.getLogLevel());
    static final Log transportLog = Log.getLog("sun.rmi.transport", "transport", logLevel);

    private static String getLogLevel() {
        return (String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.logLevel"));
    }

    public abstract Channel getChannel(Endpoint var1);

    public abstract void free(Endpoint var1);

    public void exportObject(Target target) throws RemoteException {
        ObjectTable.putTarget(target);
    }

    protected abstract void checkAcceptPermission(AccessControlContext var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serviceCall(final RemoteCall remoteCall) {
        try {
            Remote remote;
            ObjID objID;
            try {
                objID = ObjID.read(remoteCall.getInputStream());
            }
            catch (IOException iOException) {
                throw new MarshalException("unable to read objID", iOException);
            }
            Target target = ObjectTable.getTarget(objID);
            if (target == null || (remote = target.getImpl()) == null) {
                throw new NoSuchObjectException("no such object in table");
            }
            Transport transport = target.getExportedTransport();
            if (transport != null && !transport.equals(this)) {
                throw new NoSuchObjectException("no such object in table");
            }
            final Dispatcher dispatcher = target.getDispatcher();
            target.incrementCallCount();
            try {
                try {
                    transportLog.log(Log.VERBOSE, "call dispatcher");
                    final AccessControlContext accessControlContext = target.getAccessControlContext();
                    ClassLoader classLoader = target.getContextClassLoader();
                    Thread thread = Thread.currentThread();
                    ClassLoader classLoader2 = thread.getContextClassLoader();
                    try {
                        thread.setContextClassLoader(classLoader);
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    Transport.this.checkAcceptPermission(accessControlContext);
                                    dispatcher.dispatch(remote, remoteCall);
                                    return null;
                                }
                            }, accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw (IOException)privilegedActionException.getException();
                        }
                        Object var13_20 = null;
                        thread.setContextClassLoader(classLoader2);
                    }
                    catch (Throwable throwable) {
                        Object var13_21 = null;
                        thread.setContextClassLoader(classLoader2);
                        throw throwable;
                    }
                    Object var15_23 = null;
                    target.decrementCallCount();
                }
                catch (IOException iOException) {
                    boolean bl2 = false;
                    Object var15_24 = null;
                    target.decrementCallCount();
                    return bl2;
                }
            }
            catch (Throwable throwable) {
                Object var15_25 = null;
                target.decrementCallCount();
                throw throwable;
            }
        }
        catch (RemoteException remoteException) {
            Object object;
            if (UnicastServerRef.callLog.isLoggable(Log.BRIEF)) {
                object = "";
                try {
                    object = "[" + RemoteServer.getClientHost() + "] ";
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    // empty catch block
                }
                String string = (String)object + "exception: ";
                UnicastServerRef.callLog.log(Log.BRIEF, string, remoteException);
            }
            try {
                object = remoteCall.getResultStream(false);
                UnicastServerRef.clearStackTraces(remoteException);
                object.writeObject(remoteException);
                remoteCall.releaseOutputStream();
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }
}

