/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    int indexOfNextAdd = 0;
    int limit = 100;

    public UndoManager() {
        this.edits.ensureCapacity(this.limit);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void discardAllEdits() {
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            UndoableEdit undoableEdit = (UndoableEdit)enumeration.nextElement();
            undoableEdit.die();
        }
        this.edits = new Vector(this.limit);
        this.indexOfNextAdd = 0;
    }

    protected void trimForLimit() {
        int n2;
        if (this.limit > 0 && (n2 = this.edits.size()) > this.limit) {
            int n3 = this.limit / 2;
            int n4 = this.indexOfNextAdd - 1 + n3;
            int n5 = this.indexOfNextAdd - 1 - n3;
            if (n4 - n5 + 1 > this.limit) {
                ++n5;
            }
            if (n5 < 0) {
                n4 -= n5;
                n5 = 0;
            }
            if (n4 >= n2) {
                int n6 = n2 - n4 - 1;
                n4 += n6;
                n5 += n6;
            }
            this.trimEdits(n4 + 1, n2 - 1);
            this.trimEdits(0, n5 - 1);
        }
    }

    protected void trimEdits(int n2, int n3) {
        if (n2 <= n3) {
            int n4 = n3;
            while (n2 <= n4) {
                UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n4);
                undoableEdit.die();
                this.edits.removeElementAt(n4);
                --n4;
            }
            if (this.indexOfNextAdd > n3) {
                this.indexOfNextAdd -= n3 - n2 + 1;
            } else if (this.indexOfNextAdd >= n2) {
                this.indexOfNextAdd = n2;
            }
        }
    }

    public synchronized void setLimit(int n2) {
        if (!this.inProgress) {
            throw new RuntimeException("Attempt to call UndoManager.setLimit() after UndoManager.end() has been called");
        }
        this.limit = n2;
        this.trimForLimit();
    }

    protected UndoableEdit editToBeUndone() {
        int n2 = this.indexOfNextAdd;
        while (n2 > 0) {
            UndoableEdit undoableEdit;
            if (!(undoableEdit = (UndoableEdit)this.edits.elementAt(--n2)).isSignificant()) continue;
            return undoableEdit;
        }
        return null;
    }

    protected UndoableEdit editToBeRedone() {
        int n2 = this.edits.size();
        int n3 = this.indexOfNextAdd;
        while (n3 < n2) {
            UndoableEdit undoableEdit;
            if (!(undoableEdit = (UndoableEdit)this.edits.elementAt(n3++)).isSignificant()) continue;
            return undoableEdit;
        }
        return null;
    }

    protected void undoTo(UndoableEdit undoableEdit) throws CannotUndoException {
        boolean bl2 = false;
        while (!bl2) {
            UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.elementAt(--this.indexOfNextAdd);
            undoableEdit2.undo();
            boolean bl3 = bl2 = undoableEdit2 == undoableEdit;
        }
    }

    protected void redoTo(UndoableEdit undoableEdit) throws CannotRedoException {
        boolean bl2 = false;
        while (!bl2) {
            UndoableEdit undoableEdit2 = (UndoableEdit)this.edits.elementAt(this.indexOfNextAdd++);
            undoableEdit2.redo();
            boolean bl3 = bl2 = undoableEdit2 == undoableEdit;
        }
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    public synchronized boolean canUndoOrRedo() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.canUndo();
        }
        return this.canRedo();
    }

    public synchronized void undo() throws CannotUndoException {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            if (undoableEdit == null) {
                throw new CannotUndoException();
            }
            this.undoTo(undoableEdit);
        } else {
            super.undo();
        }
    }

    public synchronized boolean canUndo() {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeUndone();
            return undoableEdit != null && undoableEdit.canUndo();
        }
        return super.canUndo();
    }

    public synchronized void redo() throws CannotRedoException {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            if (undoableEdit == null) {
                throw new CannotRedoException();
            }
            this.redoTo(undoableEdit);
        } else {
            super.redo();
        }
    }

    public synchronized boolean canRedo() {
        if (this.inProgress) {
            UndoableEdit undoableEdit = this.editToBeRedone();
            return undoableEdit != null && undoableEdit.canRedo();
        }
        return super.canRedo();
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean bl2 = super.addEdit(undoableEdit);
        if (this.inProgress) {
            bl2 = true;
        }
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return bl2;
    }

    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    public synchronized String getUndoPresentationName() {
        if (this.inProgress) {
            if (this.canUndo()) {
                return this.editToBeUndone().getUndoPresentationName();
            }
            return UIManager.getString("AbstractUndoableEdit.undoText");
        }
        return super.getUndoPresentationName();
    }

    public synchronized String getRedoPresentationName() {
        if (this.inProgress) {
            if (this.canRedo()) {
                return this.editToBeRedone().getRedoPresentationName();
            }
            return UIManager.getString("AbstractUndoableEdit.redoText");
        }
        return super.getRedoPresentationName();
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.addEdit(undoableEditEvent.getEdit());
    }

    public String toString() {
        return super.toString() + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }
}

