/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.RootPaneUI;

public class BasicRootPaneUI
extends RootPaneUI
implements PropertyChangeListener {
    private static RootPaneUI rootPaneUI = new BasicRootPaneUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return rootPaneUI;
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((JRootPane)jComponent);
        this.installComponents((JRootPane)jComponent);
        this.installListeners((JRootPane)jComponent);
        this.installKeyboardActions((JRootPane)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JRootPane)jComponent);
        this.uninstallComponents((JRootPane)jComponent);
        this.uninstallListeners((JRootPane)jComponent);
        this.uninstallKeyboardActions((JRootPane)jComponent);
    }

    protected void installDefaults(JRootPane jRootPane) {
    }

    protected void installComponents(JRootPane jRootPane) {
    }

    protected void installListeners(JRootPane jRootPane) {
        jRootPane.addPropertyChangeListener(this);
    }

    protected void installKeyboardActions(JRootPane jRootPane) {
        InputMap inputMap = this.getInputMap(2, jRootPane);
        SwingUtilities.replaceUIInputMap(jRootPane, 2, inputMap);
        ActionMap actionMap = this.getActionMap(jRootPane);
        SwingUtilities.replaceUIActionMap(jRootPane, actionMap);
        this.updateDefaultButtonBindings(jRootPane);
    }

    protected void uninstallDefaults(JRootPane jRootPane) {
    }

    protected void uninstallComponents(JRootPane jRootPane) {
    }

    protected void uninstallListeners(JRootPane jRootPane) {
        jRootPane.removePropertyChangeListener(this);
    }

    protected void uninstallKeyboardActions(JRootPane jRootPane) {
        SwingUtilities.replaceUIInputMap(jRootPane, 2, null);
        SwingUtilities.replaceUIActionMap(jRootPane, null);
    }

    InputMap getInputMap(int n2, JComponent jComponent) {
        if (n2 == 2) {
            return this.createInputMap(n2, jComponent);
        }
        return null;
    }

    ActionMap getActionMap(JComponent jComponent) {
        return this.createActionMap(jComponent);
    }

    ComponentInputMap createInputMap(int n2, JComponent jComponent) {
        return new ComponentInputMapUIResource(jComponent);
    }

    ActionMap createActionMap(JComponent jComponent) {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("press", new DefaultAction((JRootPane)jComponent, true));
        actionMapUIResource.put("release", new DefaultAction((JRootPane)jComponent, false));
        return actionMapUIResource;
    }

    void updateDefaultButtonBindings(JRootPane jRootPane) {
        InputMap inputMap = SwingUtilities.getUIInputMap(jRootPane, 2);
        if (inputMap != null) {
            Object[] objectArray;
            inputMap.clear();
            if (jRootPane.getDefaultButton() != null && (objectArray = (Object[])UIManager.get("RootPane.defaultButtonWindowKeyBindings")) != null) {
                LookAndFeel.loadKeyBindings(inputMap, objectArray);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("defaultButton")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            this.updateDefaultButtonBindings(jRootPane);
            if (jRootPane.getClientProperty("temporaryDefaultButton") == null) {
                jRootPane.putClientProperty("initialDefaultButton", propertyChangeEvent.getNewValue());
            }
        }
    }

    static class DefaultAction
    extends AbstractAction {
        JRootPane root;
        boolean press;

        DefaultAction(JRootPane jRootPane, boolean bl2) {
            this.root = jRootPane;
            this.press = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = this.root.getDefaultButton();
            if (jButton != null && SwingUtilities.getRootPane(jButton) == this.root) {
                ButtonModel buttonModel = jButton.getModel();
                if (this.press) {
                    buttonModel.setArmed(true);
                    buttonModel.setPressed(true);
                    buttonModel.setPressed(false);
                }
            }
        }

        public boolean isEnabled() {
            JButton jButton = this.root.getDefaultButton();
            return jButton != null && jButton.getModel().isEnabled();
        }
    }
}

